"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExplainExporters = ExplainExporters;
exports.ExplainExportersCloud = ExplainExportersCloud;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _blurbs = require("../../blurbs");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ExplainExporters({
  reason
}) {
  const {
    context,
    property,
    data
  } = reason;
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_blurbs.ChangesNeeded, null), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    size: "half"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: "eui-textLeft"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.noData.explanations.exportersDescription",
    defaultMessage: "We checked the {context} settings for {property}, and found the reason: {data}.",
    values: {
      context: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, context),
      property: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, property),
      data: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, data)
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.noData.explanations.exporters.problemWithConfigDescription",
    defaultMessage: "Using monitoring exporters to ship the monitoring data to a remote monitoring cluster is highly recommended as it keeps the integrity of the monitoring data safe no matter what the state of the production cluster. However, as this instance of Kibana could not find any monitoring data, there seems to be a problem with the {property} configuration, or the {monitoringEs} settings in {kibanaConfig}.",
    values: {
      property: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, property),
      monitoringEs: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "xpack.monitoring.elasticsearch"),
      kibanaConfig: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "kibana.yml")
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.noData.explanations.exporters.checkConfigDescription",
    defaultMessage: "Check that the intended exporters are enabled for sending statistics to the monitoring cluster, and that the monitoring cluster host matches the {monitoringEs} setting in {kibanaConfig} to see monitoring data in this instance of Kibana.",
    values: {
      monitoringEs: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "xpack.monitoring.elasticsearch"),
      kibanaConfig: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "kibana.yml")
    }
  }))));
}
ExplainExporters.propTypes = {
  reason: _propTypes.default.object.isRequired
};
function ExplainExportersCloud() {
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_blurbs.CloudDeployment, null), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    size: "half"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: "eui-textLeft"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.noData.explanations.exportersCloudDescription",
    defaultMessage: "In Elastic Cloud, your monitoring data is stored in your dedicated monitoring cluster."
  }))));
}