"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExplainCollectionEnabled = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _blurbs = require("../../blurbs");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ExplainCollectionEnabled extends _react.default.Component {
  constructor(props) {
    super(props);
    this.handleClick = this.handleClick.bind(this);
    this.waitedTooLongTimer = null;
    this.state = {
      waitedTooLong: false
    };
  }
  componentWillUnmount() {
    clearInterval(this.waitedTooLongTimer);
  }
  handleClick() {
    const {
      enabler
    } = this.props;
    enabler.enableCollectionEnabled();

    // wait 22 seconds, show link to reload
    this.waitedTooLongTimer = setTimeout(() => {
      this.setState({
        waitedTooLong: true
      });
    }, 22 * 1000);
  }
  render() {
    const {
      reason,
      isCollectionEnabledUpdated,
      isCollectionEnabledUpdating
    } = this.props;
    const {
      property,
      data,
      context
    } = reason;
    const renderButton = () => /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_blurbs.WhatIs, null), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      size: "half"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.noData.explanations.collectionEnabledDescription",
      defaultMessage: "We checked the {context} settings and found that {property} is set to {data}.",
      values: {
        context,
        property: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, property),
        data: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, data)
      }
    })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.noData.explanations.collectionEnabled.turnItOnDescription",
      defaultMessage: "Would you like to turn it on?"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "spaceAround",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      onClick: this.handleClick,
      type: "button",
      "data-test-subj": "enableCollectionEnabled",
      isLoading: isCollectionEnabledUpdating
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.noData.explanations.collectionEnabled.turnOnMonitoringButtonLabel",
      defaultMessage: "Turn on monitoring"
    })))));
    const stillWaiting = this.state.waitedTooLong ? /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("a", {
      href: "#/"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.noData.explanations.collectionEnabled.stillWaitingLinkText",
      defaultMessage: "Still waiting?"
    }))) : null;
    const renderSuccess = () => /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "l",
      "data-test-subj": "monitoringCollectionEnabledMessage"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.noData.explanations.collectionEnabled.monitoringTurnedOnTitle",
      defaultMessage: "Success! Getting your monitoring data."
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      size: "half"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.noData.explanations.collectionEnabled.monitoringTurnedOnDescription",
      defaultMessage: "When the data is in your cluster, your monitoring dashboard will show up here. This might take a few seconds."
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), stillWaiting);

    // prettier-ignore
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, isCollectionEnabledUpdated ? renderSuccess() : renderButton());
  }
}
exports.ExplainCollectionEnabled = ExplainCollectionEnabled;
ExplainCollectionEnabled.propTypes = {
  enabler: _propTypes.default.object.isRequired,
  reason: _propTypes.default.object.isRequired,
  isCollectionEnabledUpdated: _propTypes.default.bool,
  isCollectionEnabledUpdating: _propTypes.default.bool
};