"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MONITORING_STATUS_LABEL = exports.MIGRATION_STATUS_LABEL = void 0;
exports.getDisableStatusStep = getDisableStatusStep;
exports.getMigrationStatusStep = getMigrationStatusStep;
exports.getSecurityStep = getSecurityStep;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../../common/constants");
var _common = require("../../../../common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MIGRATION_STATUS_LABEL = exports.MIGRATION_STATUS_LABEL = _i18n.i18n.translate('xpack.monitoring.metricbeatMigration.migrationStatus', {
  defaultMessage: `Migration status`
});
const MONITORING_STATUS_LABEL = exports.MONITORING_STATUS_LABEL = _i18n.i18n.translate('xpack.monitoring.metricbeatMigration.monitoringStatus', {
  defaultMessage: `Monitoring status`
});
function getSecurityStep(url) {
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "question",
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.metricbeatMigration.securitySetup",
      defaultMessage: "If security is enabled, {link} might be required.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, ` `, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: url,
          target: "_blank"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.monitoring.metricbeatMigration.securitySetupLinkText",
          defaultMessage: "additional setup"
        })))
      }
    }))
  }));
}
function getMigrationStatusStep(product) {
  if (product.isInternalCollector || product.isNetNewUser) {
    return {
      title: product.isNetNewUser ? MONITORING_STATUS_LABEL : MIGRATION_STATUS_LABEL,
      status: 'incomplete',
      children: /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        size: "s",
        color: "warning",
        title: _i18n.i18n.translate('xpack.monitoring.metricbeatMigration.isInternalCollectorStatusTitle', {
          defaultMessage: `No monitoring data detected, but we’ll continue checking.`
        })
      })
    };
  } else if (product.isPartiallyMigrated || product.isFullyMigrated) {
    return {
      title: MIGRATION_STATUS_LABEL,
      status: 'complete',
      children: /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        size: "s",
        color: "success",
        title: _i18n.i18n.translate('xpack.monitoring.metricbeatMigration.fullyMigratedStatusTitle', {
          defaultMessage: 'Congratulations!'
        })
      }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.monitoring.metricbeatMigration.fullyMigratedStatusDescription', {
        defaultMessage: 'Metricbeat is shipping monitoring data.'
      })))
    };
  }
  return null;
}
function getDisableStatusStep(product, meta) {
  if (!product || !product.isFullyMigrated) {
    let lastInternallyCollectedMessage = '';
    // It is possible that, during the migration steps, products are not reporting
    // monitoring data for a period of time outside the window of our server-side check
    // and this is most likely temporary so we want to be defensive and not error out
    // and hopefully wait for the next check and this state will be self-corrected.
    if (product) {
      const lastInternallyCollectedTimestamp = product.lastInternallyCollectedTimestamp || product.lastTimestamp;
      const secondsSinceLastInternalCollectionLabel = (0, _common.formatTimestampToDuration)(lastInternallyCollectedTimestamp, _constants.CALCULATE_DURATION_SINCE);
      lastInternallyCollectedMessage = _i18n.i18n.translate('xpack.monitoring.metricbeatMigration.disableInternalCollection.partiallyMigratedStatusDescription', {
        defaultMessage: 'Last self monitoring was {secondsSinceLastInternalCollectionLabel} ago.',
        values: {
          secondsSinceLastInternalCollectionLabel
        }
      });
    }
    return {
      title: MIGRATION_STATUS_LABEL,
      status: 'incomplete',
      children: /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        size: "s",
        color: "warning",
        title: _i18n.i18n.translate('xpack.monitoring.metricbeatMigration.partiallyMigratedStatusTitle', {
          defaultMessage: `Data is still coming from self monitoring`
        })
      }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.monitoring.metricbeatMigration.partiallyMigratedStatusDescription', {
        defaultMessage: `It can take up to {secondsAgo} seconds to detect data.`,
        values: {
          secondsAgo: meta.secondsAgo
        }
      })), /*#__PURE__*/_react.default.createElement("p", null, lastInternallyCollectedMessage))
    };
  }
  return {
    title: MIGRATION_STATUS_LABEL,
    status: 'complete',
    children: /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      size: "s",
      color: "success",
      title: _i18n.i18n.translate('xpack.monitoring.metricbeatMigration.disableInternalCollection.fullyMigratedStatusTitle', {
        defaultMessage: 'Congratulations!'
      })
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.monitoring.metricbeatMigration.disableInternalCollection.fullyMigratedStatusDescription', {
      defaultMessage: 'We are not seeing any documents from self monitoring. Migration complete!'
    })))
  };
}