"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnterpriseSearchOverview = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _chart = require("../../chart");
var _status = require("./status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EnterpriseSearchOverview = ({
  metrics,
  stats,
  ...rest
}) => {
  const lowLevelUsageMetrics = [metrics.enterprise_search_heap, metrics.enterprise_search_jvm_finalizer_queue, metrics.enterprise_search_gc_time, metrics.enterprise_search_gc_rate, metrics.enterprise_search_threads, metrics.enterprise_search_threads_rate];
  const networkMetrics = [metrics.enterprise_search_http_traffic, metrics.enterprise_search_http_responses, metrics.enterprise_search_http_connections_current, metrics.enterprise_search_http_connections_rate];
  const appSearchUsageMetrics = [metrics.app_search_total_engines, metrics.crawler_workers];
  const workplaceSearchUsageMetrics = [metrics.workplace_search_total_sources];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.entSearch.overview.heading",
    defaultMessage: "Enterprise Search Overview"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_status.Status, {
    stats: stats
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.entSearch.overview.networkingSummary",
    defaultMessage: "Network Traffic Summary"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    gutterSize: "s"
  }, networkMetrics.map((metric, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index
  }, /*#__PURE__*/_react.default.createElement(_chart.MonitoringTimeseriesContainer, (0, _extends2.default)({
    series: metric
  }, rest)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.entSearch.overview.lowLevelSummary",
    defaultMessage: "Low Level Resource Usage Summary"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    gutterSize: "s"
  }, lowLevelUsageMetrics.map((metric, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index
  }, /*#__PURE__*/_react.default.createElement(_chart.MonitoringTimeseriesContainer, (0, _extends2.default)({
    series: metric
  }, rest)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.entSearch.overview.appSearchSummary",
    defaultMessage: "App Search Summary"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    gutterSize: "s"
  }, appSearchUsageMetrics.map((metric, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index
  }, /*#__PURE__*/_react.default.createElement(_chart.MonitoringTimeseriesContainer, (0, _extends2.default)({
    series: metric
  }, rest)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.entSearch.overview.workplaceSearchSummary",
    defaultMessage: "Workplace Search Summary"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    gutterSize: "s"
  }, workplaceSearchUsageMetrics.map((metric, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index
  }, /*#__PURE__*/_react.default.createElement(_chart.MonitoringTimeseriesContainer, (0, _extends2.default)({
    series: metric
  }, rest)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)))))));
};
exports.EnterpriseSearchOverview = EnterpriseSearchOverview;