"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmMetrics = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _chart = require("../chart");
var _apm_agent = require("../../lib/apm_agent");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createCharts = (series, props) => {
  return series.map((data, index) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      style: {
        minWidth: '45%'
      },
      key: index
    }, /*#__PURE__*/_react.default.createElement(_chart.MonitoringTimeseriesContainer, (0, _extends2.default)({}, props, {
      series: data
    })));
  });
};
const getHeading = isFleetTypeMetric => {
  const titles = {};
  if (isFleetTypeMetric) {
    titles.title = _i18n.i18n.translate('xpack.monitoring.apm.metrics.topCharts.agentTitle', {
      defaultMessage: 'Integrations Server - Resource Usage'
    });
    titles.heading = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.apm.metrics.agentHeading",
      defaultMessage: "Integrations Server"
    });
    return titles;
  }
  titles.title = _i18n.i18n.translate('xpack.monitoring.apm.metrics.topCharts.title', {
    defaultMessage: 'APM Server - Resource Usage'
  });
  titles.heading = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.apm.metrics.heading",
    defaultMessage: "APM server"
  });
  return titles;
};
const ApmMetrics = ({
  stats,
  metrics,
  seriesToShow,
  title,
  summary,
  StatusComponent,
  ...props
}) => {
  if (!metrics) {
    return null;
  }
  const versions = summary !== null && summary !== void 0 && summary.version ? [summary === null || summary === void 0 ? void 0 : summary.version] : stats.versions;
  const isFleetTypeMetric = (0, _apm_agent.checkAgentTypeMetric)(versions);
  const titles = getHeading(isFleetTypeMetric);
  const topSeries = [metrics.apm_cpu, metrics.apm_os_load];
  const {
    config
  } = summary || stats;
  topSeries.push(config.container ? metrics.apm_memory_cgroup : metrics.apm_memory);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("h1", null, titles.heading)), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(StatusComponent, {
    stats: stats
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h3", null, titles.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true
  }, createCharts(topSeries, props))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h3", null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true
  }, createCharts(seriesToShow, props)))));
};
exports.ApmMetrics = ApmMetrics;