"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validation$ = exports.getSyntaxErrors = exports.getSuggestionProvider = void 0;
var _rxjs = require("rxjs");
var _monaco_imports = require("../monaco_imports");
var _constants = require("./constants");
var _lib = require("./lib");
var _completion_adapter = require("./completion_adapter");
var _diagnostics_adapter = require("../common/diagnostics_adapter");
var _worker_proxy = require("../common/worker_proxy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const workerProxyService = new _worker_proxy.WorkerProxyService();
const editorStateService = new _lib.EditorStateService();
const worker = (...uris) => {
  return workerProxyService.getWorker(uris);
};
const getSuggestionProvider = (context, fields) => {
  editorStateService.setup(context, fields);
  return new _completion_adapter.PainlessCompletionAdapter(worker, editorStateService);
};
exports.getSuggestionProvider = getSuggestionProvider;
let diagnosticsAdapter;

// Returns syntax errors for all models by model id
const getSyntaxErrors = () => {
  var _diagnosticsAdapter$g, _diagnosticsAdapter;
  return (_diagnosticsAdapter$g = (_diagnosticsAdapter = diagnosticsAdapter) === null || _diagnosticsAdapter === void 0 ? void 0 : _diagnosticsAdapter.getSyntaxErrors()) !== null && _diagnosticsAdapter$g !== void 0 ? _diagnosticsAdapter$g : {};
};
exports.getSyntaxErrors = getSyntaxErrors;
const validation$ = () => {
  var _diagnosticsAdapter2;
  return ((_diagnosticsAdapter2 = diagnosticsAdapter) === null || _diagnosticsAdapter2 === void 0 ? void 0 : _diagnosticsAdapter2.validation$) || (0, _rxjs.of)({
    isValid: true,
    isValidating: false,
    errors: []
  });
};
exports.validation$ = validation$;
_monaco_imports.monaco.languages.onLanguage(_constants.ID, async () => {
  workerProxyService.setup(_constants.ID);
  diagnosticsAdapter = new _diagnostics_adapter.DiagnosticsAdapter(_constants.ID, worker);
});