"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESQL_AUTOCOMPLETE_TRIGGER_CHARS = exports.ESQLLang = void 0;
var _esqlValidationAutocomplete = require("@kbn/esql-validation-autocomplete");
var _monacoEsql = require("@elastic/monaco-esql");
var monarchDefinitions = _interopRequireWildcard(require("@elastic/monaco-esql/lib/definitions"));
var _constants = require("./lib/constants");
var _theme = require("./lib/theme");
var _suggestions = require("./lib/converters/suggestions");
var _positions = require("./lib/converters/positions");
var _hover = require("./lib/hover/hover");
var _utils = require("./lib/shared/utils");
var _monaco_imports = require("../monaco_imports");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const removeKeywordSuffix = name => {
  return name.endsWith('.keyword') ? name.slice(0, -8) : name;
};
const ESQL_AUTOCOMPLETE_TRIGGER_CHARS = exports.ESQL_AUTOCOMPLETE_TRIGGER_CHARS = ['(', ' ', '[', '?'];
const ESQLLang = exports.ESQLLang = {
  ID: _constants.ESQL_LANG_ID,
  async onLanguage() {
    const language = _monacoEsql.monarch.create({
      ...monarchDefinitions,
      functions: _esqlValidationAutocomplete.esqlFunctionNames
    });
    _monaco_imports.monaco.languages.setMonarchTokensProvider(_constants.ESQL_LANG_ID, language);
  },
  languageThemeResolver: _theme.buildEsqlTheme,
  languageConfiguration: {
    brackets: [['(', ')'], ['[', ']']],
    autoClosingPairs: [{
      open: '(',
      close: ')'
    }, {
      open: '[',
      close: ']'
    }, {
      open: `'`,
      close: `'`
    }, {
      open: '"""',
      close: '"""'
    }, {
      open: '"',
      close: '"'
    }],
    surroundingPairs: [{
      open: '(',
      close: ')'
    }, {
      open: `'`,
      close: `'`
    }, {
      open: '"""',
      close: '"""'
    }, {
      open: '"',
      close: '"'
    }]
  },
  validate: async (model, code, callbacks) => {
    const text = code !== null && code !== void 0 ? code : model.getValue();
    const {
      errors,
      warnings
    } = await (0, _esqlValidationAutocomplete.validateQuery)(text, undefined, callbacks);
    const monacoErrors = (0, _positions.wrapAsMonacoMessages)(text, errors);
    const monacoWarnings = (0, _positions.wrapAsMonacoMessages)(text, warnings);
    return {
      errors: monacoErrors,
      warnings: monacoWarnings
    };
  },
  getHoverProvider: callbacks => {
    return {
      async provideHover(model, position, token) {
        return (0, _hover.getHoverItem)(model, position, callbacks);
      }
    };
  },
  getSuggestionProvider: callbacks => {
    return {
      triggerCharacters: ESQL_AUTOCOMPLETE_TRIGGER_CHARS,
      async provideCompletionItems(model, position, context) {
        const fullText = model.getValue();
        const offset = (0, _utils.monacoPositionToOffset)(fullText, position);
        const suggestions = await (0, _esqlValidationAutocomplete.suggest)(fullText, offset, context, callbacks);
        return {
          // @ts-expect-error because of range typing: https://github.com/microsoft/monaco-editor/issues/4638
          suggestions: (0, _suggestions.wrapAsMonacoSuggestions)(suggestions, fullText)
        };
      },
      async resolveCompletionItem(item, token) {
        if (!(callbacks !== null && callbacks !== void 0 && callbacks.getFieldsMetadata)) return item;
        const fieldsMetadataClient = await (callbacks === null || callbacks === void 0 ? void 0 : callbacks.getFieldsMetadata);
        const fullEcsMetadataList = await (fieldsMetadataClient === null || fieldsMetadataClient === void 0 ? void 0 : fieldsMetadataClient.find({
          attributes: ['type']
        }));
        if (!fullEcsMetadataList || !fieldsMetadataClient || typeof item.label !== 'string') return item;
        const strippedFieldName = removeKeywordSuffix(item.label);
        if (
        // If item is not a field, no need to fetch metadata
        item.kind === _monaco_imports.monaco.languages.CompletionItemKind.Variable &&
        // If not ECS, no need to fetch description
        Object.hasOwn(fullEcsMetadataList === null || fullEcsMetadataList === void 0 ? void 0 : fullEcsMetadataList.fields, strippedFieldName)) {
          const ecsMetadata = await fieldsMetadataClient.find({
            fieldNames: [strippedFieldName],
            attributes: ['description']
          });
          const fieldMetadata = ecsMetadata.fields[strippedFieldName];
          if (fieldMetadata && fieldMetadata.description) {
            const completionItem = {
              ...item,
              documentation: {
                value: fieldMetadata.description
              }
            };
            return completionItem;
          }
        }
        return item;
      }
    };
  }
};