"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calendarSchema = exports.calendarIdsSchema = exports.calendarIdSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const calendarSchema = exports.calendarSchema = _configSchema.schema.object({
  calendarId: _configSchema.schema.string(),
  calendar_id: _configSchema.schema.maybe(_configSchema.schema.string()),
  job_ids: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  description: _configSchema.schema.maybe(_configSchema.schema.string()),
  total_job_count: _configSchema.schema.maybe(_configSchema.schema.number()),
  events: _configSchema.schema.arrayOf(_configSchema.schema.object({
    event_id: _configSchema.schema.maybe(_configSchema.schema.string()),
    calendar_id: _configSchema.schema.maybe(_configSchema.schema.string()),
    description: _configSchema.schema.maybe(_configSchema.schema.string()),
    start_time: _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.number()]),
    end_time: _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.number()]),
    skip_result: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    skip_model_update: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    force_time_shift: _configSchema.schema.maybe(_configSchema.schema.number())
  }))
});
const calendarIdSchema = exports.calendarIdSchema = _configSchema.schema.object({
  calendarId: _configSchema.schema.string()
});
const calendarIdsSchema = exports.calendarIdsSchema = _configSchema.schema.object({
  calendarIds: _configSchema.schema.string({
    meta: {
      description: 'Comma-separated list of calendar IDs'
    }
  })
});