"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mlAnomalyDetectionAlertPreviewRequest = void 0;
var _configSchema = require("@kbn/config-schema");
var _anomaly_detection = require("@kbn/response-ops-rule-params/anomaly_detection");
var _alerts = require("../../../common/constants/alerts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mlAnomalyDetectionAlertPreviewRequest = exports.mlAnomalyDetectionAlertPreviewRequest = _configSchema.schema.object({
  alertParams: _anomaly_detection.mlAnomalyDetectionAlertParamsSchema,
  /**
   * Relative time range to look back from now, e.g. 1y, 8m, 15d
   */
  timeRange: _configSchema.schema.string(),
  /**
   * Number of top hits to return
   */
  sampleSize: _configSchema.schema.number({
    defaultValue: _alerts.ALERT_PREVIEW_SAMPLE_SIZE,
    min: 0
  })
});