"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dataVisualizerRoutes = dataVisualizerRoutes;
var _app = require("../../common/constants/app");
var _error_wrapper = require("../client/error_wrapper");
var _data_visualizer = require("../models/data_visualizer");
var _data_visualizer_schema = require("./schemas/data_visualizer_schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getHistogramsForFields(client, indexPattern, query, fields, samplerShardSize, runtimeMappings) {
  const dv = new _data_visualizer.DataVisualizer(client);
  return dv.getHistogramsForFields(indexPattern, query, fields, samplerShardSize, runtimeMappings);
}

/**
 * Routes for the index data visualizer.
 */
function dataVisualizerRoutes({
  router,
  routeGuard
}) {
  router.versioned.post({
    path: `${_app.ML_INTERNAL_BASE_PATH}/data_visualizer/get_field_histograms/{indexPattern}`,
    access: 'internal',
    security: {
      authz: {
        requiredPrivileges: ['ml:canGetFieldInfo']
      }
    },
    summary: 'Gets histograms for fields',
    description: 'Returns the histograms on a list fields in the specified index pattern.'
  }).addVersion({
    version: '1',
    validate: {
      request: {
        params: _data_visualizer_schema.indexPatternSchema,
        body: _data_visualizer_schema.dataVisualizerFieldHistogramsSchema
      },
      response: {
        200: {
          body: _data_visualizer_schema.dataVisualizerFieldHistogramsResponse,
          description: 'Histograms by field, keyed on the name of the field.'
        }
      }
    }
  }, routeGuard.basicLicenseAPIGuard(async ({
    client,
    request,
    response
  }) => {
    try {
      const {
        params: {
          indexPattern
        },
        body: {
          query,
          fields,
          samplerShardSize,
          runtimeMappings
        }
      } = request;
      const results = await getHistogramsForFields(client, indexPattern, query, fields, samplerShardSize, runtimeMappings);
      return response.ok({
        body: results
      });
    } catch (e) {
      return response.customError((0, _error_wrapper.wrapError)(e));
    }
  }));
}