"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.anomalyLayerWizard = void 0;
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/maps-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const anomalyLayerWizard = exports.anomalyLayerWizard = {
  categories: [_common.LAYER_WIZARD_CATEGORY.SOLUTIONS, _common.LAYER_WIZARD_CATEGORY.ELASTICSEARCH],
  description: _i18n.i18n.translate('xpack.ml.maps.anomalyLayerDescription', {
    defaultMessage: 'Display anomalies from a machine learning job'
  }),
  disabledReason: _i18n.i18n.translate('xpack.ml.maps.anomalyLayerUnavailableMessage', {
    defaultMessage: 'Anomalies layers are a subscription feature. Ensure you have the right subscription and access to Machine Learning.'
  }),
  icon: 'outlierDetectionJob',
  getIsDisabled: () => {
    // return false by default
    return false;
  },
  title: _i18n.i18n.translate('xpack.ml.maps.anomalyLayerTitle', {
    defaultMessage: 'ML Anomalies'
  }),
  order: 100
};