"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractParams = extractParams;
exports.formatGenericMlUrl = formatGenericMlUrl;
var _lodash = require("lodash");
var _public = require("@kbn/kibana-utils-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function extractParams(urlState) {
  // page should be guaranteed to exist here but <UrlState> is unknown
  // @ts-ignore
  const {
    page,
    ...params
  } = urlState;
  return {
    page,
    params
  };
}

/**
 * Creates generic index based search ML url
 * e.g. `jobs/new_job/datavisualizer?index=3da93760-e0af-11ea-9ad3-3bcfc330e42a`
 */
function formatGenericMlUrl(appBasePath, page, pageState) {
  let url = `${appBasePath}/${page}`;
  if (pageState) {
    const {
      globalState,
      appState,
      index,
      savedSearchId,
      ...restParams
    } = pageState;
    if (index !== undefined && savedSearchId === undefined) {
      url = `${url}?index=${index}`;
    }
    if (index === undefined && savedSearchId !== undefined) {
      url = `${url}?savedSearchId=${savedSearchId}`;
    }
    if (!(0, _lodash.isEmpty)(restParams)) {
      Object.keys(restParams).forEach(key => {
        url = (0, _public.setStateToKbnUrl)(key, restParams[key], {
          useHash: false,
          storeInHashQuery: false
        }, url);
      });
    }
    if (globalState) {
      url = (0, _public.setStateToKbnUrl)('_g', globalState, {
        useHash: false,
        storeInHashQuery: false
      }, url);
    }
    if (appState) {
      url = (0, _public.setStateToKbnUrl)('_a', appState, {
        useHash: false,
        storeInHashQuery: false
      }, url);
    }
  }
  return url;
}