"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildDataViewPublishingApi = void 0;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildDataViewPublishingApi = (services, api, subscription) => {
  const dataViews$ = new _rxjs.BehaviorSubject(undefined);
  subscription.add(api.jobIds.pipe(
  // Get job definitions
  (0, _rxjs.switchMap)(jobIds => services.anomalyDetectorService.getJobs$(jobIds)),
  // Get unique indices from the datafeed configs
  (0, _rxjs.map)(jobs => [...new Set(jobs.map(j => j.datafeed_config.indices).flat())]), (0, _rxjs.switchMap)(indices => (0, _rxjs.forkJoin)(indices.map(indexName => (0, _rxjs.from)(services.dataViewsService.find(`"${indexName}"`).then(r => {
    const dView = r.find(obj => obj.getIndexPattern().toLowerCase().includes(indexName.toLowerCase()));
    return dView;
  }))))), (0, _rxjs.map)(results => {
    return results.flat().filter(dView => dView !== undefined);
  })).subscribe(dataViews$));
  return dataViews$;
};
exports.buildDataViewPublishingApi = buildDataViewPublishingApi;