"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findMessageField = findMessageField;
exports.getDataViewAndSavedSearchCallback = void 0;
exports.getQueryFromSavedSearchObject = getQueryFromSavedSearchObject;
exports.isCcsIndexPattern = isCcsIndexPattern;
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDataViewAndSavedSearchCallback = deps => async savedSearchId => {
  var _ss$references, _ss$references$find;
  const resp = {
    savedSearch: null,
    dataView: null
  };
  if (savedSearchId === undefined) {
    return resp;
  }
  const ss = await deps.savedSearchService.get(savedSearchId);
  if (ss === null) {
    return resp;
  }
  const dataViewId = (_ss$references = ss.references) === null || _ss$references === void 0 ? void 0 : (_ss$references$find = _ss$references.find(r => r.type === 'index-pattern')) === null || _ss$references$find === void 0 ? void 0 : _ss$references$find.id;
  resp.dataView = await deps.dataViewsService.get(dataViewId);
  resp.savedSearch = ss;
  return resp;
};
exports.getDataViewAndSavedSearchCallback = getDataViewAndSavedSearchCallback;
function getQueryFromSavedSearchObject(savedSearch) {
  return {
    query: savedSearch.searchSource.getField('query'),
    filter: savedSearch.searchSource.getField('filter')
  };
}

/**
 * Returns true if the index pattern contains a :
 * which means it is cross-cluster
 */
function isCcsIndexPattern(indexPattern) {
  return (0, _esQuery.isCCSRemoteIndexName)(indexPattern);
}
function findMessageField(dataView) {
  const foundFields = {
    message: null,
    errorMessage: null
  };
  for (const f of dataView.fields) {
    var _f$toSpec$esTypes, _f$toSpec$esTypes2;
    if (f.name === 'message' && (_f$toSpec$esTypes = f.toSpec().esTypes) !== null && _f$toSpec$esTypes !== void 0 && _f$toSpec$esTypes.includes('text')) {
      foundFields.message = f;
    } else if (f.name === 'error.message' && (_f$toSpec$esTypes2 = f.toSpec().esTypes) !== null && _f$toSpec$esTypes2 !== void 0 && _f$toSpec$esTypes2.includes('text')) {
      foundFields.errorMessage = f;
    }
  }
  if (foundFields.message !== null) {
    return {
      dataView,
      field: foundFields.message
    };
  } else if (foundFields.errorMessage !== null) {
    return {
      dataView,
      field: foundFields.errorMessage
    };
  }
  return null;
}