"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OutputLoadingContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OutputLoadingContent = ({
  text
}) => {
  const actualLines = text.split(/\r\n|\r|\n/).length + 1;
  const lines = actualLines > 4 && actualLines <= 10 ? actualLines : 4;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    "data-test-subj": 'mlTestModelLoadingContent',
    lines: lines
  });
};
exports.OutputLoadingContent = OutputLoadingContent;