"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTextEmbeddingOutputComponent = void 0;
var _react = _interopRequireDefault(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTextEmbeddingOutputComponent = inferrer => /*#__PURE__*/_react.default.createElement(TextEmbeddingOutput, {
  inferrer: inferrer
});
exports.getTextEmbeddingOutputComponent = getTextEmbeddingOutputComponent;
const TextEmbeddingOutput = ({
  inferrer
}) => {
  const result = (0, _useObservable.default)(inferrer.getInferenceResult$(), inferrer.getInferenceResult());
  if (!result) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, result.map(({
    response,
    inputText
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(TextEmbedding, {
    value: response.predictedValue.toString(),
    inputText: inputText
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null))));
};
const TextEmbedding = ({
  value,
  inputText
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, inputText), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    value: value,
    fullWidth: true,
    style: {
      height: 300
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: value
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    onClick: copy
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.testModelsFlyout.textEmbedding.copyButton",
    defaultMessage: "Copy to clipboard"
  }))));
};