"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InputFormControls = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InputFormControls = ({
  testButtonDisabled,
  createPipelineButtonDisabled,
  inferrer,
  showCreatePipelineButton
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: testButtonDisabled,
    fullWidth: false,
    "data-test-subj": 'mlTestModelTestButton',
    type: 'submit'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.testModelsFlyout.inferenceInputForm.runButton",
    defaultMessage: "Test"
  }))), showCreatePipelineButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    disabled: createPipelineButtonDisabled,
    "data-test-subj": 'mlTestModelCreatePipelineButton',
    onClick: () => {
      if (inferrer.switchToCreationMode) {
        inferrer.switchToCreationMode();
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.testModelsFlyout.inferenceInputForm.createPipelineButton",
    defaultMessage: "Create pipeline"
  }))) : null);
};
exports.InputFormControls = InputFormControls;