"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RareFieldSelect = void 0;
var _react = _interopRequireDefault(require("react"));
var _mlFieldStatsFlyout = require("@kbn/ml-field-stats-flyout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RareFieldSelect = ({
  fields,
  changeHandler,
  selectedField,
  testSubject,
  placeholder
}) => {
  const {
    optionCss
  } = (0, _mlFieldStatsFlyout.useFieldStatsTrigger)();
  const options = fields.map(f => ({
    label: f.name,
    field: f,
    css: optionCss
  }));
  const selection = [];
  if (selectedField !== null) {
    selection.push({
      label: selectedField.name,
      field: selectedField
    });
  }
  function onChange(selectedOptions) {
    const option = selectedOptions[0];
    if (typeof option !== 'undefined') {
      changeHandler(option.field);
    } else {
      changeHandler(null);
    }
  }
  return /*#__PURE__*/_react.default.createElement(_mlFieldStatsFlyout.OptionListWithFieldStats, {
    singleSelection: {
      asPlainText: true
    },
    options: options,
    selectedOptions: selection,
    onChange: onChange,
    placeholder: placeholder,
    "data-test-subj": testSubject,
    isClearable: false
  });
};
exports.RareFieldSelect = RareFieldSelect;