"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldExamples = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TOKEN_HIGHLIGHT_COLOR = '#b0ccf7';
const FieldExamples = ({
  fieldExamples
}) => {
  if (fieldExamples === null || fieldExamples.length === 0) {
    return null;
  }
  const columns = [{
    field: 'example',
    name: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.categorizationFieldExamples.title', {
      defaultMessage: 'Examples'
    }),
    render: example => /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      fontSize: "s",
      paddingSize: "none",
      transparentBackground: true,
      style: {
        maxHeight: '200px'
      } // Don't use overflowHeight as don't want to show the fullscreen button
    }, example)
  }];
  const items = fieldExamples.map((example, i) => {
    const txt = [];
    let tokenCounter = 0;
    let buffer = '';
    let charCount = 0;
    while (charCount < example.text.length) {
      const token = example.tokens[tokenCounter];
      if (token && charCount === token.start_offset) {
        txt.push(buffer);
        buffer = '';
        txt.push(/*#__PURE__*/_react.default.createElement(Token, {
          key: `${i}${charCount}`
        }, token.token));
        charCount += token.end_offset - token.start_offset;
        tokenCounter++;
      } else {
        buffer += example.text[charCount];
        charCount++;
      }
    }
    txt.push(buffer);
    return {
      example: txt
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    items: items,
    "data-test-subj": "mlJobWizardCategorizationExamplesTable"
  });
};
exports.FieldExamples = FieldExamples;
const Token = ({
  children
}) => /*#__PURE__*/_react.default.createElement("span", {
  style: {
    backgroundColor: TOKEN_HIGHLIGHT_COLOR
  }
}, children);