"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChangeDataView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _description = require("./description");
var _change_data_view = require("./change_data_view");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChangeDataView = ({
  isDisabled
}) => {
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showFlyout && /*#__PURE__*/_react.default.createElement(_change_data_view.ChangeDataViewModal, {
    onClose: setShowFlyout.bind(null, false)
  }), /*#__PURE__*/_react.default.createElement(_description.Description, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: setShowFlyout.bind(null, true),
    isDisabled: isDisabled,
    "data-test-subj": "mlJobsImportButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.datafeedStep.dataView.changeDataView.button",
    defaultMessage: "Change data view"
  }))));
};
exports.ChangeDataView = ChangeDataView;