"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverlayRange = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _mlDateUtils = require("@kbn/ml-date-utils");
var _charts = require("@elastic/charts");
var _kibana = require("../../../../../../contexts/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OverlayRange = ({
  overlayKey,
  start,
  end,
  color,
  showMarker = true
}) => {
  const {
    euiTheme
  } = (0, _kibana.useCurrentThemeVars)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_charts.RectAnnotation, {
    id: `rect_annotation_${overlayKey}`,
    zIndex: 1,
    hideTooltips: true,
    dataValues: [{
      coordinates: {
        x0: start,
        x1: end
      }
    }],
    style: {
      fill: color,
      strokeWidth: 0
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: "annotation_1",
    domainType: _charts.AnnotationDomainType.XDomain,
    dataValues: [{
      dataValue: start
    }],
    style: {
      line: {
        strokeWidth: 1,
        opacity: 0
      }
    },
    markerPosition: _charts.Position.Bottom,
    hideTooltips: true,
    marker: showMarker ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "arrowUp"
    }) : undefined,
    markerBody: showMarker ? /*#__PURE__*/_react.default.createElement("div", {
      style: {
        fontWeight: 'normal',
        color: euiTheme.euiTextColor
      }
    }, (0, _mlDateUtils.timeFormatter)(start)) : undefined
  }));
};
exports.OverlayRange = OverlayRange;