"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isManagedJob = void 0;
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isManagedJob = job => {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(job, ['customSettings']) && job.customSettings.managed === true || (0, _mlIsPopulatedObject.isPopulatedObject)(job, ['custom_settings']) && job.custom_settings.managed === true;
};
exports.isManagedJob = isManagedJob;