"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupSelectorUI = exports.GroupSelector = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _check_capabilities = require("../../../../../capabilities/check_capabilities");
var _group_list = require("./group_list");
var _new_group_input = require("./new_group_input");
var _toast_notification_service = require("../../../../../services/toast_notification_service");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createSelectedGroups(jobs, groups) {
  const jobIds = jobs.map(j => j.id);
  const groupCounts = {};
  jobs.forEach(j => {
    j.groups.forEach(g => {
      if (groupCounts[g] === undefined) {
        groupCounts[g] = 0;
      }
      groupCounts[g]++;
    });
  });
  const selectedGroups = groups.reduce((p, c) => {
    if (c.jobIds.some(j => jobIds.includes(j))) {
      p[c.id] = {
        partial: groupCounts[c.id] !== jobIds.length
      };
    }
    return p;
  }, {});
  return selectedGroups;
}
class GroupSelectorUI extends _react.Component {
  constructor(props, constructorContext) {
    super(props, constructorContext);
    (0, _defineProperty2.default)(this, "togglePopover", () => {
      if (this.state.isPopoverOpen) {
        this.closePopover();
      } else {
        const mlApi = this.props.kibana.services.mlServices.mlApi;
        mlApi.jobs.groups().then(groups => {
          const selectedGroups = createSelectedGroups(this.props.jobs, groups);
          this.setState({
            isPopoverOpen: true,
            edited: false,
            selectedGroups,
            groups
          });
        }).catch(error => {
          console.error(error);
        });
      }
    });
    (0, _defineProperty2.default)(this, "closePopover", () => {
      this.setState({
        edited: false,
        isPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "selectGroup", group => {
      const newSelectedGroups = (0, _lodash.cloneDeep)(this.state.selectedGroups);
      if (newSelectedGroups[group.id] === undefined) {
        newSelectedGroups[group.id] = {
          partial: false
        };
      } else if (newSelectedGroups[group.id].partial === true) {
        newSelectedGroups[group.id].partial = false;
      } else {
        delete newSelectedGroups[group.id];
      }
      this.setState({
        selectedGroups: newSelectedGroups,
        edited: true
      });
    });
    (0, _defineProperty2.default)(this, "applyChanges", () => {
      const toastNotificationsService = this.toastNotificationsService;
      const {
        selectedGroups
      } = this.state;
      const {
        jobs
      } = this.props;
      const newJobs = jobs.map(j => ({
        id: j.id,
        oldGroups: j.groups,
        newGroups: []
      }));
      for (const gId in selectedGroups) {
        if (Object.hasOwn(selectedGroups, gId)) {
          const group = selectedGroups[gId];
          newJobs.forEach(j => {
            if (group.partial === false || group.partial === true && j.oldGroups.includes(gId)) {
              j.newGroups.push(gId);
            }
          });
        }
      }
      const tempJobs = newJobs.map(j => ({
        jobId: j.id,
        groups: j.newGroups
      }));
      const mlApi = this.props.kibana.services.mlServices.mlApi;
      mlApi.jobs.updateGroups(tempJobs).then(resp => {
        let success = true;
        for (const jobId in resp) {
          // check success of each job update
          if (Object.hasOwn(resp, jobId)) {
            if (resp[jobId].success === false) {
              toastNotificationsService.displayErrorToast(resp[jobId].error);
              success = false;
            }
          }
        }
        if (success) {
          // if all are successful refresh the job list
          this.refreshJobs();
          this.closePopover();
        } else {
          console.error(resp);
        }
      }).catch(error => {
        toastNotificationsService.displayErrorToast(error);
        console.error(error);
      });
    });
    (0, _defineProperty2.default)(this, "addNewGroup", id => {
      const newGroup = {
        id,
        calendarIds: [],
        jobIds: []
      };
      const groups = this.state.groups;
      if (groups.some(g => g.id === newGroup.id) === false) {
        groups.push(newGroup);
      }
      this.setState({
        groups
      });
    });
    this.state = {
      isPopoverOpen: false,
      groups: [],
      selectedGroups: {},
      edited: false
    };
    this.refreshJobs = this.props.refreshJobs;
    this.canUpdateJob = (0, _check_capabilities.checkPermission)('canUpdateJob');
    this.toastNotificationsService = (0, _toast_notification_service.toastNotificationServiceProvider)(props.kibana.services.notifications.toasts);
  }
  static getDerivedStateFromProps(props, state) {
    if (state.edited === false) {
      const selectedGroups = createSelectedGroups(props.jobs, state.groups);
      return {
        selectedGroups
      };
    } else {
      return {};
    }
  }
  render() {
    const {
      groups,
      selectedGroups,
      edited
    } = this.state;
    const button = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "bottom",
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.multiJobActions.groupSelector.editJobGroupsButtonTooltip",
        defaultMessage: "Edit job groups"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "indexEdit",
      "aria-label": _i18n.i18n.translate('xpack.ml.jobsList.multiJobActions.groupSelector.editJobGroupsButtonAriaLabel', {
        defaultMessage: 'Edit job groups'
      }),
      onClick: () => this.togglePopover(),
      disabled: this.canUpdateJob === false,
      "data-test-subj": "mlADJobListMultiSelectEditJobGroupsButton"
    }));
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "trapFocus",
      ownFocus: true,
      button: button,
      isOpen: this.state.isPopoverOpen,
      closePopover: () => this.closePopover()
    }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.multiJobActions.groupSelector.applyGroupsToJobTitle",
      defaultMessage: "Apply groups to {jobsCount, plural, one {job} other {jobs}}",
      values: {
        jobsCount: this.props.jobs.length
      }
    })), /*#__PURE__*/_react.default.createElement(_group_list.GroupList, {
      groups: groups,
      selectedGroups: selectedGroups,
      selectGroup: this.selectGroup
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "xs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_new_group_input.NewGroupInput, {
      addNewGroup: this.addNewGroup,
      allJobIds: this.props.allJobIds
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "m"
    }), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      onClick: this.applyChanges,
      isDisabled: edited === false
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.multiJobActions.groupSelector.applyButtonLabel",
      defaultMessage: "Apply"
    })))))));
  }
}
exports.GroupSelectorUI = GroupSelectorUI;
(0, _defineProperty2.default)(GroupSelectorUI, "propTypes", {
  jobs: _propTypes.default.array.isRequired,
  allJobIds: _propTypes.default.array.isRequired,
  refreshJobs: _propTypes.default.func.isRequired
});
const GroupSelector = exports.GroupSelector = (0, _public.withKibana)(GroupSelectorUI);