"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnFailureConfiguration = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _codeEditor = require("@kbn/code-editor");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _save_changes_button = require("../ml_inference/components/save_changes_button");
var _state = require("../ml_inference/state");
var _constants = require("../ml_inference/constants");
var _kibana = require("../../contexts/kibana");
var _validation_utils = require("../../../../common/util/validation_utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OnFailureConfiguration = exports.OnFailureConfiguration = /*#__PURE__*/(0, _react.memo)(({
  handleAdvancedConfigUpdate,
  ignoreFailure,
  onFailure,
  takeActionOnFailure
}) => {
  const {
    services: {
      docLinks: {
        links
      }
    }
  } = (0, _kibana.useMlKibana)();
  const [editOnFailure, setEditOnFailure] = (0, _react.useState)(false);
  const [isOnFailureValid, setIsOnFailureValid] = (0, _react.useState)(false);
  const [onFailureString, setOnFailureString] = (0, _react.useState)(JSON.stringify(onFailure, null, 2));
  const updateIgnoreFailure = e => {
    const checked = e.target.checked;
    handleAdvancedConfigUpdate({
      ignoreFailure: checked,
      ...(checked === true ? {
        takeActionOnFailure: false,
        onFailure: undefined
      } : {})
    });
  };
  const updateOnFailure = () => {
    handleAdvancedConfigUpdate({
      onFailure: JSON.parse(onFailureString)
    });
    setEditOnFailure(false);
  };
  const handleOnFailureChange = json => {
    setOnFailureString(json);
    const valid = (0, _validation_utils.isValidJson)(json);
    setIsOnFailureValid(valid);
  };
  const handleTakeActionOnFailureChange = checked => {
    handleAdvancedConfigUpdate({
      takeActionOnFailure: checked,
      onFailure: checked === false ? undefined : (0, _state.getDefaultOnFailureConfiguration)()
    });
    if (checked === false) {
      setEditOnFailure(false);
      setIsOnFailureValid(true);
    }
  };
  const resetOnFailure = () => {
    setOnFailureString(JSON.stringify((0, _state.getDefaultOnFailureConfiguration)(), null, 2));
    setIsOnFailureValid(true);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    "data-test-subj": "mlTrainedModelsInferenceOnFailureStep"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.advanced.onFailureTitle', {
    defaultMessage: 'Ingesting problematic documents'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.advanced.handleFailuresExplanation",
    defaultMessage: "If the model fails to produce a prediction, the document will be ingested without the prediction."
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.advanced.handleFailuresDescription",
    defaultMessage: "By default, pipeline processing stops on failure. To run the pipeline's remaining processors despite the failure, {ignoreFailure} is set to true. {inferenceDocsLink}.",
    values: {
      ignoreFailure: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'ignore_failure'),
      inferenceDocsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        target: "_blank",
        href: links.ingest.pipelineFailure
      }, "Learn more.")
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.advanced.onFailureDescription",
    defaultMessage: "The {onFailure} configuration shown will be used as a default. It is used to specify a list of processors to run immediately after the inference processor failure and provides information on why the failure occurred. {onFailureDocsLink}",
    values: {
      onFailure: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'on_failure'),
      onFailureDocsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        target: "_blank",
        href: links.ingest.pipelineFailure
      }, "Learn more.")
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": 'mlTrainedModelsInferenceIgnoreFailureSwitch',
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.advanced.ignoreFailureLabel",
      defaultMessage: "Ignore failure and run the pipeline's remaining processors"
    }),
    checked: ignoreFailure,
    onChange: updateIgnoreFailure
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, ignoreFailure === false ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": 'mlTrainedModelsInferenceTakeActionOnFailureSwitch',
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.advanced.noActionOnFailureLabel",
      defaultMessage: "Take action on failure"
    })),
    checked: takeActionOnFailure,
    onChange: e => handleTakeActionOnFailureChange(e.target.checked)
  })) : null))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, takeActionOnFailure === true && ignoreFailure === false ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.advanced.onFailureHeadingLabel', {
      defaultMessage: 'Actions to take on failure'
    }))),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      justifyContent: "flexEnd"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "pencil",
      size: "xs",
      onClick: () => {
        setEditOnFailure(!editOnFailure);
      }
    }, editOnFailure ? _constants.CANCEL_EDIT_MESSAGE : _constants.EDIT_MESSAGE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, editOnFailure ? /*#__PURE__*/_react.default.createElement(_save_changes_button.SaveChangesButton, {
      onClick: updateOnFailure,
      disabled: isOnFailureValid === false
    }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, editOnFailure ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      onClick: resetOnFailure
    }, _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.advanced.resetOnFailureButton', {
      defaultMessage: 'Reset'
    })) : null)),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.advanced.onFailureHelpText",
      defaultMessage: "In case of failure, this configuration stores the document, provides the timestamp at which ingest failed, and the context for the failure."
    })
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !editOnFailure ? /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    "data-test-subj": "mlTrainedModelsInferenceOnFailureCodeBlock",
    isCopyable: true,
    overflowHeight: 350,
    css: {
      height: '350px'
    }
  }, JSON.stringify(onFailure, null, 2)) : null, editOnFailure ? /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    "data-test-subj": "mlTrainedModelsInferenceOnFailureEditor",
    height: 300,
    languageId: "json",
    options: {
      automaticLayout: true,
      lineNumbers: 'off',
      tabSize: 2
    },
    value: onFailureString,
    onChange: handleOnFailureChange
  }) : null)) : null))))));
});