"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeRangeBar = TimeRangeBar;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = require("prop-types");
var _eui = require("@elastic/eui");
var _timerange_bar_styles = require("./timerange_bar_styles");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TimeRangeBar({
  isRunning,
  timerange,
  ganttBarWidth
}) {
  const styles = (0, _timerange_bar_styles.useTimerangeBarStyles)();
  const style = {
    width: timerange.widthPx,
    marginLeft: timerange.fromPx
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: timerange.label
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.ganttBarBackEdge
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.ganttBarDashed,
    style: {
      width: `${ganttBarWidth}px`
    }
  })), /*#__PURE__*/_react.default.createElement("div", {
    css: [styles.ganttBar, ...(isRunning ? [styles.ganttBarRunning] : [])],
    style: style,
    "data-test-subj": `mlJobSelectorGanttBar${isRunning ? 'Running' : ''}`
  })));
}
TimeRangeBar.propTypes = {
  ganttBarWidth: _propTypes.PropTypes.number,
  isRunning: _propTypes.PropTypes.bool,
  timerange: _propTypes.PropTypes.shape({
    widthPx: _propTypes.PropTypes.number,
    label: _propTypes.PropTypes.string,
    fromPx: _propTypes.PropTypes.number
  })
};