"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isMlKibanaUrlConfigWithTimeRange = isMlKibanaUrlConfigWithTimeRange;
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Base Interface for basic custom URL.
 */

/**
 * Extended interface for custom URLs including an optional time range.
 */

/**
 * Extended interface for custom URLs including a time range.
 */

/**
 * Union type of different custom URL configurations
 */

/**
 * Extended interface of MlAnomalyRecordDoc to include time range information.
 */

/**
 * Type guard to idenfity MlKibanaUrlConfigWithTimeRange.
 *
 * @param {unknown} arg The unknown type to be evaluated
 * @returns {arg is MlKibanaUrlConfigWithTimeRange} whether arg is of type MlKibanaUrlConfigWithTimeRange
 */
function isMlKibanaUrlConfigWithTimeRange(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['url_name', 'url_value', 'time_range']) && typeof arg.time_range === 'string';
}