"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TX_LABEL = exports.RX_LABEL = exports.NORMALIZED_LOAD_LABEL = exports.NETWORK_LABEL = exports.MEMORY_USAGE_LABEL = exports.MEMORY_FREE_LABEL = exports.LOAD_LABEL = exports.LOAD_5M_LABEL = exports.LOAD_1M_LABEL = exports.LOAD_15M_LABEL = exports.DISK_WRITE_THROUGHPUT_LABEL = exports.DISK_WRITE_IOPS_LABEL = exports.DISK_USAGE_LABEL = exports.DISK_USAGE_BY_MOUNT_POINT_LABEL = exports.DISK_USAGE_AVERAGE_LABEL = exports.DISK_THROUGHPUT_LABEL = exports.DISK_SPACE_AVAILABLE_LABEL = exports.DISK_SPACE_AVAILABILITY_LABEL = exports.DISK_READ_THROUGHPUT_LABEL = exports.DISK_READ_IOPS_LABEL = exports.DISK_IOPS_LABEL = exports.DEFAULT_XY_YBOUNDS = exports.DEFAULT_XY_LEGEND = exports.DEFAULT_XY_HIDDEN_LEGEND = exports.DEFAULT_XY_HIDDEN_AXIS_TITLE = exports.DEFAULT_XY_FITTING_FUNCTION = exports.CPU_USAGE_LABEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_XY_FITTING_FUNCTION = exports.DEFAULT_XY_FITTING_FUNCTION = {
  fittingFunction: 'Linear'
};
const DEFAULT_XY_HIDDEN_LEGEND = exports.DEFAULT_XY_HIDDEN_LEGEND = {
  legend: {
    show: false
  }
};
const DEFAULT_XY_LEGEND = exports.DEFAULT_XY_LEGEND = {
  legend: {
    position: 'bottom',
    show: true
  }
};
const DEFAULT_XY_YBOUNDS = exports.DEFAULT_XY_YBOUNDS = {
  yBounds: {
    mode: 'custom',
    lowerBound: 0,
    upperBound: 1
  }
};
const DEFAULT_XY_HIDDEN_AXIS_TITLE = exports.DEFAULT_XY_HIDDEN_AXIS_TITLE = {
  axisTitleVisibility: {
    showXAxisTitle: false,
    showYAxisTitle: false
  }
};
const CPU_USAGE_LABEL = exports.CPU_USAGE_LABEL = _i18n.i18n.translate('xpack.metricsData.assetDetails.metrics.label.cpuUsage', {
  defaultMessage: 'CPU Usage'
});
const MEMORY_USAGE_LABEL = exports.MEMORY_USAGE_LABEL = _i18n.i18n.translate('xpack.metricsData.assetDetails.metrics.label.memoryUsage', {
  defaultMessage: 'Memory Usage'
});
const MEMORY_FREE_LABEL = exports.MEMORY_FREE_LABEL = _i18n.i18n.translate('xpack.metricsData.assetDetails.metrics.label.memoryFree', {
  defaultMessage: 'Memory Free'
});
const LOAD_LABEL = exports.LOAD_LABEL = _i18n.i18n.translate('xpack.metricsData.assetDetails.metrics.label.load', {
  defaultMessage: 'Load'
});
const LOAD_1M_LABEL = exports.LOAD_1M_LABEL = _i18n.i18n.translate('xpack.metricsData.assetDetails.metrics.label.load1m', {
  defaultMessage: 'Load (1m)'
});
const LOAD_5M_LABEL = exports.LOAD_5M_LABEL = _i18n.i18n.translate('xpack.metricsData.assetDetails.metrics.label.load5m', {
  defaultMessage: 'Load (5m)'
});
const LOAD_15M_LABEL = exports.LOAD_15M_LABEL = _i18n.i18n.translate('xpack.metricsData.assetDetails.metrics.label.load15m', {
  defaultMessage: 'Load (15m)'
});
const NORMALIZED_LOAD_LABEL = exports.NORMALIZED_LOAD_LABEL = _i18n.i18n.translate('xpack.metricsData.assetDetails.metrics.label.normalizedLoad', {
  defaultMessage: 'Normalized Load'
});
const DISK_USAGE_LABEL = exports.DISK_USAGE_LABEL = _i18n.i18n.translate('xpack.metricsData.assetDetails.metrics.label.diskUsage', {
  defaultMessage: 'Disk Usage'
});
const DISK_USAGE_AVERAGE_LABEL = exports.DISK_USAGE_AVERAGE_LABEL = _i18n.i18n.translate('xpack.metricsData.assetDetails.metrics.label.diskUsageAverage', {
  defaultMessage: 'Disk Usage Average'
});
const DISK_IOPS_LABEL = exports.DISK_IOPS_LABEL = _i18n.i18n.translate('xpack.metricsData.assetDetails.metrics.label.diskIOPS', {
  defaultMessage: 'Disk IOPS'
});
const DISK_READ_IOPS_LABEL = exports.DISK_READ_IOPS_LABEL = _i18n.i18n.translate('xpack.metricsData.assetDetails.metrics.label.diskReadIOPS', {
  defaultMessage: 'Disk Read IOPS'
});
const DISK_WRITE_IOPS_LABEL = exports.DISK_WRITE_IOPS_LABEL = _i18n.i18n.translate('xpack.metricsData.assetDetails.metrics.label.diskWriteIOPS', {
  defaultMessage: 'Disk Write IOPS'
});
const DISK_USAGE_BY_MOUNT_POINT_LABEL = exports.DISK_USAGE_BY_MOUNT_POINT_LABEL = _i18n.i18n.translate('xpack.metricsData.assetDetails.metrics.label.diskUsageByMountingPoint', {
  defaultMessage: 'Disk Usage by Mount Point'
});
const DISK_THROUGHPUT_LABEL = exports.DISK_THROUGHPUT_LABEL = _i18n.i18n.translate('xpack.metricsData.assetDetails.metrics.label.diskThroughput', {
  defaultMessage: 'Disk Throughput'
});
const DISK_READ_THROUGHPUT_LABEL = exports.DISK_READ_THROUGHPUT_LABEL = _i18n.i18n.translate('xpack.metricsData.assetDetails.metrics.label.diskReadThroughput', {
  defaultMessage: 'Disk Read Throughput'
});
const DISK_WRITE_THROUGHPUT_LABEL = exports.DISK_WRITE_THROUGHPUT_LABEL = _i18n.i18n.translate('xpack.metricsData.assetDetails.metrics.label.diskWriteThroughput', {
  defaultMessage: 'Disk Write Throughput'
});
const DISK_SPACE_AVAILABLE_LABEL = exports.DISK_SPACE_AVAILABLE_LABEL = _i18n.i18n.translate('xpack.metricsData.assetDetails.metrics.label.diskSpaceAvailable', {
  defaultMessage: 'Disk Space Available'
});
const DISK_SPACE_AVAILABILITY_LABEL = exports.DISK_SPACE_AVAILABILITY_LABEL = _i18n.i18n.translate('xpack.metricsData.assetDetails.metrics.label.diskSpaceAvailablity', {
  defaultMessage: 'Disk Space Availability'
});
const NETWORK_LABEL = exports.NETWORK_LABEL = _i18n.i18n.translate('xpack.metricsData.assetDetails.metrics.label.network', {
  defaultMessage: 'Network'
});
const RX_LABEL = exports.RX_LABEL = _i18n.i18n.translate('xpack.metricsData.assetDetails.metrics.label.networkRx', {
  defaultMessage: 'Inbound (RX)'
});
const TX_LABEL = exports.TX_LABEL = _i18n.i18n.translate('xpack.metricsData.assetDetails.metrics.label.networkTx', {
  defaultMessage: 'Outbound (TX)'
});