"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logs = void 0;
var _formulas = require("../formulas");
var _constants = require("../../../shared/charts/constants");
var _formulas$logRate$lab;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const logRate = {
  id: 'logRate',
  chartType: 'xy',
  title: (_formulas$logRate$lab = _formulas.formulas.logRate.label) !== null && _formulas$logRate$lab !== void 0 ? _formulas$logRate$lab : '',
  layers: [{
    seriesType: 'line',
    type: 'series',
    xAxis: '@timestamp',
    yAxis: [_formulas.formulas.logRate]
  }],
  ..._constants.DEFAULT_XY_FITTING_FUNCTION,
  ..._constants.DEFAULT_XY_HIDDEN_LEGEND,
  ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
};
const logs = exports.logs = {
  xy: {
    logRate
  }
};