"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dockerContainerNetworkTx = exports.dockerContainerNetworkRx = void 0;
var _constants = require("../../../shared/charts/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dockerContainerNetworkRx = exports.dockerContainerNetworkRx = {
  label: _constants.RX_LABEL,
  value: "average(docker.network.inbound.bytes) * 8 / (max(metricset.period, kql='docker.network.inbound.bytes: *') / 1000)",
  format: 'bits',
  decimals: 1,
  normalizeByUnit: 's'
};
const dockerContainerNetworkTx = exports.dockerContainerNetworkTx = {
  label: _constants.TX_LABEL,
  value: "average(docker.network.outbound.bytes) * 8 / (max(metricset.period, kql='docker.network.outbound.bytes: *') / 1000)",
  format: 'bits',
  decimals: 1,
  normalizeByUnit: 's'
};