"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formulas = void 0;
var _cpu = require("./cpu");
var _disk = require("./disk");
var _memory = require("./memory");
var _network = require("./network");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formulas = exports.formulas = {
  dockerContainerCpuUsage: _cpu.dockerContainerCpuUsage,
  dockerContainerMemoryUsage: _memory.dockerContainerMemoryUsage,
  dockerContainerNetworkRx: _network.dockerContainerNetworkRx,
  dockerContainerNetworkTx: _network.dockerContainerNetworkTx,
  dockerContainerDiskIORead: _disk.dockerContainerDiskIORead,
  dockerContainerDiskIOWrite: _disk.dockerContainerDiskIOWrite,
  k8sContainerCpuUsage: _cpu.k8sContainerCpuUsage,
  k8sContainerMemoryUsage: _memory.k8sContainerMemoryUsage
};