/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
"use strict";(self.maps_bundle_jsonpfunction=self.maps_bundle_jsonpfunction||[]).push([[354],{70508:(e,t,s)=>{s.d(t,{l:()=>a}),s(84286);var i=s(96791);const a=()=>(0,i.jsx)("svg",{xmlns:"http://www.w3.org/2000/svg",width:"49",height:"25",fill:"none",viewBox:"0 0 49 25",className:"mapLayersWizardIcon"},(0,i.jsx)("path",{className:"mapLayersWizardIcon__background",d:"M30.501 14.511l1.602-12.954-1.388.236c-.744.254-1.768.38-2.703.45-.463.034-.899.055-1.258.07l-.093.005c-.311.014-.57.025-.72.042a1.895 1.895 0 00-.558.167 7.55 7.55 0 00-.47.238l-.057.031c-.356.19-.686.357-1.025.4l-1.307.338v5.864c0 .697.141 2.168 0 3.443l-.205 1.67h8.182zM20.607 3.249c-.657.038-1.248.281-2.06.398l-.703.103c-.583.087-1.16.172-1.692.238-.751.093-1.39.145-1.82.113-.593-.044-1.125.341-1.611.843-.453.467-.925 1.101-1.429 1.777l-.144.193c-1.132 1.517-2.452 3.218-4.22 4.102-.213.107-.346.312-.431.528a3.07 3.07 0 00-.173.78c-.064.586-.046 1.324.007 2.083.072 1.01.211 2.102.32 2.955.055.42.101.784.128 1.05.08.78-.128 1.77-.37 2.653-.088.319-.178.616-.258.882l-.086.285a9.67 9.67 0 00-.12.434 1.518 1.518 0 00-.053.334c0 .28.11.577.283.842a2.3 2.3 0 00.735.708l.067.04h.078c4.133-.069 10.221-.555 10.973-.639a.581.581 0 00.333-.17c.083-.08.158-.181.225-.293.134-.223.263-.524.387-.867.25-.69.495-1.6.721-2.519.161-.654.544-1.41.682-2.011l.784-2.796c.067-.379.199-1.13.272-1.704.147-1.149-.01-2.54.097-4 .107-1.458.172-2.917.147-4.052a10.13 10.13 0 00-.113-1.438 2.469 2.469 0 00-.131-.495c-.052-.128-.276-.357-.276-.357h-.55zM31.538 15.87s-1.17-.652-1.548-.643c-.758.02-1.298-.026-2.353 0H22.15l-2.864 8.915c.2.067 1.938.445 2.242.447.62.005 1.478-.08 2.393-.197.88-.112 1.824-.257 2.679-.389l.112-.017c.888-.136 1.664-.254 2.166-.304.348-.035.996-.025 1.858-.007l.128.002c.827.017 1.818.037 2.868.023 2.199-.028 4.695-.203 6.5-.887 1.42-.538 2.1-.87 2.513-1.339.414-.469.575-1.576.575-1.576s-2.906.867-4.807.784c-.927-.041-1.507.044-2.352-.341-1.428-.652-1.205-2.22-2.429-3.205-.771-.62-2.194-1.267-2.194-1.267z"}),(0,i.jsx)("path",{className:"mapLayersWizardIcon__background",d:"M33.058 1.625S31.012 14.8 31.455 15.023c.787.393 2.012.664 3.137 1.67 1.23 1.1 1.172 2.5 2.318 3.239.835.538 6.525-.704 6.525-.704l.228-7.956s-.173-4.5-.89-5.215c-.715-.716-2.488-1.125-3-2.08-1.114-2.081-3.068-2.352-3.068-2.352h-3.647z"}),(0,i.jsx)("circle",{cx:"14.761",cy:"9.754",r:"1.091",className:"mapLayersWizardIcon__highlight"}),(0,i.jsx)("circle",{cx:"36.63",cy:"10.706",r:"1.091",className:"mapLayersWizardIcon__highlight"}),(0,i.jsx)("circle",{cx:"24.842",cy:"19.181",r:"1.091",className:"mapLayersWizardIcon__highlight"}),(0,i.jsx)("circle",{cx:"39.024",cy:"15.363",r:"1.091",className:"mapLayersWizardIcon__highlight"}),(0,i.jsx)("circle",{cx:"27.569",cy:"6.091",r:"1.091",className:"mapLayersWizardIcon__highlight"}),(0,i.jsx)("circle",{cx:"28.66",cy:"11",r:"1.091",className:"mapLayersWizardIcon__highlight"}),(0,i.jsx)("circle",{cx:"35.206",cy:"4.454",r:"1.091",className:"mapLayersWizardIcon__highlight"}),(0,i.jsx)("circle",{cx:"18.842",cy:"6.091",r:"1.091",className:"mapLayersWizardIcon__highlight"}),(0,i.jsx)("circle",{cx:"10.115",cy:"13.727",r:"1.091",className:"mapLayersWizardIcon__highlight"}),(0,i.jsx)("circle",{cx:"16.66",cy:"14.818",r:"1.091",className:"mapLayersWizardIcon__highlight"}),(0,i.jsx)("circle",{cx:"11.206",cy:"20.272",r:"1.091",className:"mapLayersWizardIcon__highlight"}),(0,i.jsx)("circle",{cx:"17.751",cy:"20.818",r:"1.091",className:"mapLayersWizardIcon__highlight"}),(0,i.jsx)("circle",{cx:"30.842",cy:"20.818",r:"1.091",className:"mapLayersWizardIcon__highlight"}))},81668:(e,t,s)=>{s.d(t,{q:()=>p}),s(84286);var i=s(81319),a=s(75008),o=s(3746),r=s(96791);const l="timeseries",n="terms",d=[{id:l,label:o.J4},{id:n,label:o.HJ}];function p({groupByTimeseries:e,onGroupByTimeseriesChange:t}){return(0,r.jsx)(i.EuiButtonGroup,{type:"single",legend:a.i18n.translate("xpack.maps.source.esGeoLine.groupByButtonGroupLegend",{defaultMessage:"Choose group by method"}),options:d,idSelected:e?l:n,onChange:e=>{t(e===l)},isFullWidth:!0,buttonSize:"compressed"})}},3746:(e,t,s)=>{s.d(t,{HJ:()=>o,J4:()=>a,XW:()=>l,qo:()=>r});var i=s(75008);const a=i.i18n.translate("xpack.maps.source.esGeoLine.groupBy.timeseriesLabel",{defaultMessage:"Time series"}),o=i.i18n.translate("xpack.maps.source.esGeoLine.groupBy.termsLabel",{defaultMessage:"Top terms"}),r=i.i18n.translate("xpack.maps.source.esGeoLine.splitFieldLabel",{defaultMessage:"Entity"}),l=i.i18n.translate("xpack.maps.source.esGeoLine.sortFieldLabel",{defaultMessage:"Sort"})},49354:(e,t,s)=>{s.d(t,{Md:()=>ESSearchSource,a9:()=>Y,createLayerDescriptor:()=>J,L8:()=>K,e1:()=>D});var i=s(22787),a=s(68915),o=s(30770),r=s.n(o),l=s(84286),n=s.n(l),d=s(75008),p=s(55964),c=s(80190),u=s(7195),h=s(30690),g=s(48275),m=s(99723),x=s(184),f=s(81319),S=s(14627),_=s(75879),y=s(80055),F=s(52141),T=s(18708),w=s(53898),M=s(73353),v=s(43721);let j=!1;const C=new Map;async function P(e){if(C.has(e))return C.get(e);const t=async function(e){const t=(0,m.PA)(),s=(0,m.dt)();try{return await t.fetch(i.Mj,{method:"GET",credentials:"same-origin",version:"1",query:{indexPatternTitle:e}})}catch(t){const a=d.i18n.translate("xpack.maps.indexSettings.fetchErrorMsg",{defaultMessage:"Unable to fetch index settings for data view ''{indexPatternTitle}''.\n      Ensure you have ''{viewIndexMetaRole}'' role.",values:{indexPatternTitle:e,viewIndexMetaRole:"view_index_metadata"}});return j||(j=!0,s.addWarning(a)),v.warn(a),{maxResultWindow:i.SV,maxInnerResultWindow:i.Rk}}}(e);return C.set(e,t),t}var E=s(96791);function b(e){const[t,s]=(0,l.useState)(!1);return(0,E.jsx)(f.EuiPopover,{id:"scalingHelpPopover",anchorPosition:"leftCenter",button:(0,E.jsx)(f.EuiButtonIcon,{onClick:()=>{s(!t)},iconType:"documentation","aria-label":"Scaling documentation"}),isOpen:t,closePopover:()=>{s(!1)},repositionOnScroll:!0,ownFocus:!0},(0,E.jsx)(f.EuiPopoverTitle,null,(0,E.jsx)(_.FormattedMessage,{id:"xpack.maps.scalingDocs.title",defaultMessage:"Scaling"})),(0,E.jsx)("div",null,(0,E.jsx)(f.EuiText,{size:"s",style:{maxWidth:"36em"}},(0,E.jsx)("dl",null,(0,E.jsx)("dt",null,e.mvtOptionLabel," (Default)"),(0,E.jsx)("dd",null,(0,E.jsx)("p",null,(0,E.jsx)(_.FormattedMessage,{id:"xpack.maps.scalingDocs.mvtDetails",defaultMessage:"Vector tiles partition your map into tiles, with each tile displaying features from the first {maxResultWindow} documents. Results exceeding {maxResultWindow} are not displayed in a tile. A bounding box indicates the area where data is incomplete.",values:{maxResultWindow:e.maxResultWindow}})),(0,E.jsx)("p",null,(0,E.jsx)(_.FormattedMessage,{id:"xpack.maps.scalingDocs.mvtUseCase",defaultMessage:"Use this option to display large data sets with the fastest loading times."}))),(0,E.jsx)("dt",null,e.clustersOptionLabel),(0,E.jsx)("dd",null,(0,E.jsx)("p",null,(0,E.jsx)(_.FormattedMessage,{id:"xpack.maps.scalingDocs.clustersDetails",defaultMessage:"Display clusters when results exceed {maxResultWindow} documents. Display documents when results are less then {maxResultWindow}.",values:{maxResultWindow:e.maxResultWindow}})),(0,E.jsx)("p",null,(0,E.jsx)(_.FormattedMessage,{id:"xpack.maps.scalingDocs.clustersUseCase",defaultMessage:"Use this option to display large data sets. "}),(0,E.jsx)("i",null,(0,E.jsx)(_.FormattedMessage,{id:"xpack.maps.scalingDocs.doesNotSupportJoins",defaultMessage:"Does not support joins."})))),(0,E.jsx)("dt",null,e.limitOptionLabel),(0,E.jsx)("dd",null,(0,E.jsx)("p",null,(0,E.jsx)(_.FormattedMessage,{id:"xpack.maps.scalingDocs.limitDetails",defaultMessage:"Display features from the first {maxResultWindow} documents.",values:{maxResultWindow:e.maxResultWindow}})),(0,E.jsx)(_.FormattedMessage,{id:"xpack.maps.scalingDocs.limitUseCases",defaultMessage:"Use this option when you can not use vector tiles for the following reasons:"}),(0,E.jsx)("ul",null,(0,E.jsx)("li",null,(0,E.jsx)(_.FormattedMessage,{id:"xpack.maps.scalingDocs.limitUseCase.formatLabels",defaultMessage:"Formatted labels"})),(0,E.jsx)("li",null,(0,E.jsx)(_.FormattedMessage,{id:"xpack.maps.scalingDocs.limitUseCase.multipleJoins",defaultMessage:"Spatial joins"})),(0,E.jsx)("li",null,(0,E.jsx)(_.FormattedMessage,{id:"xpack.maps.scalingDocs.limitUseCase.spatialJoins",defaultMessage:"Multiple term joins"})),(0,E.jsx)("li",null,(0,E.jsx)(_.FormattedMessage,{id:"xpack.maps.scalingDocs.limitUseCase.joinFieldsWithLayoutStyles",defaultMessage:"Data driven styling from join metrics with 'Label', 'Label size', icon 'Symbol size', and 'Symbol orientation' style properties"})),(0,E.jsx)("li",null,(0,E.jsx)(_.FormattedMessage,{id:"xpack.maps.scalingDocs.limitUseCase.scriptedFields",defaultMessage:"Data driven styling from scripted fields"}))))),(0,E.jsx)("p",{style:{fontStyle:"italic"}},(0,E.jsx)(_.FormattedMessage,{id:"xpack.maps.scalingDocs.maxResultWindow",defaultMessage:"{maxResultWindow} constraint provided by {link} index setting.",values:{maxResultWindow:e.maxResultWindow,link:(0,E.jsx)(f.EuiLink,{href:(0,m.g9)().links.elasticsearch.dynamicIndexSettings,target:"_blank",external:!0},"max_result_window")}})))))}class ScalingForm extends l.Component{constructor(...e){super(...e),(0,a.default)(this,"state",{maxResultWindow:i.SV.toLocaleString(),modalContent:null,showModal:!1}),(0,a.default)(this,"_isMounted",!1),(0,a.default)(this,"_onScalingTypeSelect",(e=>{if(this.props.numberOfJoins>0&&e===i.wj.CLUSTERS)this._openModal(e,[d.i18n.translate("xpack.maps.source.esSearch.clusterScalingJoinMsg",{defaultMessage:"Scaling with clusters does not support joins. Switching to clusters will remove all joins from your layer configuration."})]);else{if(e===i.wj.MVT){const t=[];if(this.props.hasSpatialJoins&&t.push(d.i18n.translate("xpack.maps.source.esSearch.mvtNoSpatialJoinMsg",{defaultMessage:"Vector tiles do not support spatial joins. Switching to vector tiles will remove all spatial joins from your layer configuration."})),this.props.numberOfJoins>1&&t.push(d.i18n.translate("xpack.maps.source.esSearch.mvtScalingJoinMsg",{defaultMessage:"Vector tiles support one term join. Your layer has {numberOfJoins} joins. Switching to vector tiles will keep the first term join and remove all other joins from your layer configuration.",values:{numberOfJoins:this.props.numberOfJoins}})),t.length)return void this._openModal(e,t)}this._onScalingTypeChange(e)}})),(0,a.default)(this,"_onScalingTypeChange",(e=>{let t;t=e===i.wj.CLUSTERS?i.Nl.BLENDED_VECTOR:e===i.wj.MVT?i.Nl.MVT_VECTOR:i.Nl.GEOJSON_VECTOR,this.props.onChange({propName:"scalingType",value:e,newLayerType:t})})),(0,a.default)(this,"_onFilterByMapBoundsChange",(e=>{this.props.onChange({propName:"filterByMapBounds",value:e.target.checked})})),(0,a.default)(this,"_openModal",((e,t)=>{this.setState({modalContent:t.length?t.map(((e,t)=>(0,E.jsx)("p",{key:t},e))):null,nextScalingType:e,showModal:!0})})),(0,a.default)(this,"_closeModal",(()=>{this.setState({modalContent:null,nextScalingType:void 0,showModal:!1})})),(0,a.default)(this,"_acceptModal",(()=>{this.state.nextScalingType&&this._onScalingTypeChange(this.state.nextScalingType),this._closeModal()}))}componentDidMount(){this._isMounted=!0,this.loadIndexSettings()}componentWillUnmount(){this._isMounted=!1}async loadIndexSettings(){try{const e=await(0,m.Mh)().get(this.props.indexPatternId),{maxResultWindow:t}=await P(e.getIndexPattern());this._isMounted&&this.setState({maxResultWindow:t.toLocaleString()})}catch(e){return}}_getLimitOptionLabel(){return d.i18n.translate("xpack.maps.source.esSearch.limitScalingLabel",{defaultMessage:"Limit results to {maxResultWindow}",values:{maxResultWindow:this.state.maxResultWindow}})}_getClustersOptionLabel(){return d.i18n.translate("xpack.maps.source.esSearch.clusterScalingLabel",{defaultMessage:"Show clusters when results exceed {maxResultWindow}",values:{maxResultWindow:this.state.maxResultWindow}})}_getMvtOptionLabel(){return d.i18n.translate("xpack.maps.source.esSearch.useMVTVectorTiles",{defaultMessage:"Use vector tiles"})}_renderModal(){return this.state.showModal&&this.state.modalContent&&void 0!==this.state.nextScalingType?(0,E.jsx)(f.EuiConfirmModal,{title:d.i18n.translate("xpack.maps.source.esSearch.scalingModal.title",{defaultMessage:"Remove unsupported configurations?"}),onCancel:this._closeModal,onConfirm:this._acceptModal,cancelButtonText:d.i18n.translate("xpack.maps.source.esSearch.scalingModal.cancelBtnLabel",{defaultMessage:"Cancel"}),confirmButtonText:d.i18n.translate("xpack.maps.source.esSearch.scalingModal.confirmBtnLabel",{defaultMessage:"Accept"}),buttonColor:"danger",defaultFocusedButton:"cancel"},this.state.modalContent):null}_renderClusteringRadio(){const e=(0,E.jsx)(f.EuiRadio,{id:i.wj.CLUSTERS,label:this._getClustersOptionLabel(),checked:this.props.scalingType===i.wj.CLUSTERS,onChange:()=>this._onScalingTypeSelect(i.wj.CLUSTERS),disabled:!this.props.supportsClustering});return this.props.clusteringDisabledReason?(0,E.jsx)(f.EuiToolTip,{position:"left",content:this.props.clusteringDisabledReason},e):e}render(){let e;return this.props.scalingType===i.wj.LIMIT&&(e=(0,E.jsx)(f.EuiFormRow,null,(0,E.jsx)(f.EuiSwitch,{label:d.i18n.translate("xpack.maps.source.esSearch.extentFilterLabel",{defaultMessage:"Dynamically filter for data in the visible map area"}),checked:this.props.filterByMapBounds,onChange:this._onFilterByMapBoundsChange,compressed:!0}))),(0,E.jsx)(l.Fragment,null,this._renderModal(),(0,E.jsx)(f.EuiTitle,{size:"xs"},(0,E.jsx)("h5",null,(0,E.jsx)(_.FormattedMessage,{id:"xpack.maps.esSearch.scaleTitle",defaultMessage:"Scaling"})," ",(0,E.jsx)(b,{limitOptionLabel:this._getLimitOptionLabel(),clustersOptionLabel:this._getClustersOptionLabel(),maxResultWindow:this.state.maxResultWindow,mvtOptionLabel:this._getMvtOptionLabel()}))),(0,E.jsx)(f.EuiSpacer,{size:"m"}),(0,E.jsx)(f.EuiFormRow,null,(0,E.jsx)("div",null,(0,E.jsx)(f.EuiRadio,{id:i.wj.MVT,label:this._getMvtOptionLabel(),checked:this.props.scalingType===i.wj.MVT,onChange:()=>this._onScalingTypeSelect(i.wj.MVT)}),this._renderClusteringRadio(),(0,E.jsx)(f.EuiRadio,{id:i.wj.LIMIT,label:this._getLimitOptionLabel(),checked:this.props.scalingType===i.wj.LIMIT,onChange:()=>this._onScalingTypeSelect(i.wj.LIMIT)}))),e)}}class UpdateSourceEditor extends l.Component{constructor(...e){super(...e),(0,a.default)(this,"_isMounted",!1),(0,a.default)(this,"state",{sourceFields:null,sortFields:void 0,supportsClustering:!1,clusteringDisabledReason:null}),(0,a.default)(this,"_onTooltipPropertiesChange",(e=>{this.props.onChange({propName:"tooltipProperties",value:e})})),(0,a.default)(this,"_onSortFieldChange",(e=>{this.props.onChange({propName:"sortField",value:e})})),(0,a.default)(this,"_onSortOrderChange",(e=>{this.props.onChange({propName:"sortOrder",value:e.target.value})}))}componentDidMount(){this._isMounted=!0,this.loadFields()}componentWillUnmount(){this._isMounted=!1}async loadFields(){let e,t;try{e=await(0,m.Mh)().get(this.props.indexPatternId)}catch(e){return void(this._isMounted&&this.setState({loadError:(0,y.vv)(this.props.indexPatternId)}))}try{t=await this.props.getGeoField()}catch(e){return void(this._isMounted&&this.setState({loadError:e.message}))}if(!this._isMounted)return;const s=(0,w.pT)(e.fields).map((e=>new M.v({fieldName:e.name,source:this.props.source,origin:i.e$.SOURCE})));this.setState({supportsClustering:(0,w.V1)(t),clusteringDisabledReason:(0,w.Cy)(t),sourceFields:s,sortFields:e.fields.filter((e=>e.sortable&&!S.indexPatterns.isNestedField(e)))})}_renderTooltipsPanel(){return(0,E.jsx)(f.EuiPanel,null,(0,E.jsx)(f.EuiTitle,{size:"xs"},(0,E.jsx)("h5",null,(0,E.jsx)(_.FormattedMessage,{id:"xpack.maps.esSearch.tooltipsTitle",defaultMessage:"Tooltip fields"}))),(0,E.jsx)(f.EuiSpacer,{size:"m"}),(0,E.jsx)(T.J,{tooltipFields:this.props.tooltipFields,onChange:this._onTooltipPropertiesChange,fields:this.state.sourceFields}))}_renderSortPanel(){return(0,E.jsx)(f.EuiPanel,null,(0,E.jsx)(f.EuiTitle,{size:"xs"},(0,E.jsx)("h5",null,(0,E.jsx)(_.FormattedMessage,{id:"xpack.maps.esSearch.sortTitle",defaultMessage:"Sorting"}))),(0,E.jsx)(f.EuiSpacer,{size:"m"}),(0,E.jsx)(f.EuiFormRow,{label:d.i18n.translate("xpack.maps.source.esSearch.sortFieldLabel",{defaultMessage:"Field"}),display:"columnCompressed"},(0,E.jsx)(F.R,{placeholder:d.i18n.translate("xpack.maps.source.esSearch.sortFieldSelectPlaceholder",{defaultMessage:"Select sort field"}),value:this.props.sortField,onChange:this._onSortFieldChange,fields:this.state.sortFields,compressed:!0})),(0,E.jsx)(f.EuiFormRow,{label:d.i18n.translate("xpack.maps.source.esSearch.sortOrderLabel",{defaultMessage:"Order"}),display:"columnCompressed"},(0,E.jsx)(f.EuiSelect,{disabled:!this.props.sortField,options:[{text:d.i18n.translate("xpack.maps.source.esSearch.ascendingLabel",{defaultMessage:"ascending"}),value:S.SortDirection.asc},{text:d.i18n.translate("xpack.maps.source.esSearch.descendingLabel",{defaultMessage:"descending"}),value:S.SortDirection.desc}],value:this.props.sortOrder,onChange:this._onSortOrderChange,compressed:!0})))}_renderScalingPanel(){return(0,E.jsx)(f.EuiPanel,null,(0,E.jsx)(ScalingForm,{filterByMapBounds:this.props.filterByMapBounds,indexPatternId:this.props.indexPatternId,onChange:this.props.onChange,scalingType:this.props.scalingType,supportsClustering:this.state.supportsClustering,clusteringDisabledReason:this.state.clusteringDisabledReason,hasSpatialJoins:this.props.hasSpatialJoins,numberOfJoins:this.props.numberOfJoins}))}render(){return(0,E.jsx)(l.Fragment,null,this._renderTooltipsPanel(),(0,E.jsx)(f.EuiSpacer,{size:"s"}),this._renderSortPanel(),(0,E.jsx)(f.EuiSpacer,{size:"s"}),this._renderScalingPanel(),(0,E.jsx)(f.EuiSpacer,{size:"s"}))}}var I=s(67871),L=s(595),k=s(70005),H=s(81668);class TopHitsForm extends l.Component{constructor(...e){super(...e),(0,a.default)(this,"state",{maxInnerResultWindow:i.Rk}),(0,a.default)(this,"_isMounted",!1),(0,a.default)(this,"_onGroupByTimeseriesChange",(e=>{this.props.onChange({propName:"topHitsGroupByTimeseries",value:e})})),(0,a.default)(this,"_onTopHitsSplitFieldChange",(e=>{e&&this.props.onChange({propName:"topHitsSplitField",value:e})})),(0,a.default)(this,"_onTopHitsSizeChange",(e=>{this.props.onChange({propName:"topHitsSize",value:e})})),(0,a.default)(this,"_onSortFieldChange",(e=>{this.props.onChange({propName:"sortField",value:e})})),(0,a.default)(this,"_onSortOrderChange",(e=>{this.props.onChange({propName:"sortOrder",value:e.target.value})}))}componentDidMount(){this._isMounted=!0,this.loadIndexSettings()}componentWillUnmount(){this._isMounted=!1}async loadIndexSettings(){try{const e=await(0,m.Mh)().get(this.props.indexPatternId),{maxInnerResultWindow:t}=await P(e.getIndexPattern());this._isMounted&&this.setState({maxInnerResultWindow:t})}catch(e){return}}render(){return(0,E.jsx)(l.Fragment,null,this.props.isTimeseries&&(0,E.jsx)(f.EuiFormRow,{label:d.i18n.translate("xpack.maps.source.esSearch.topHitsGroupByLabel",{defaultMessage:"Group by"}),display:this.props.isColumnCompressed?"columnCompressed":"row"},(0,E.jsx)(H.q,{groupByTimeseries:this.props.topHitsGroupByTimeseries,onGroupByTimeseriesChange:this._onGroupByTimeseriesChange})),!this.props.topHitsGroupByTimeseries&&(0,E.jsx)(f.EuiFormRow,{label:d.i18n.translate("xpack.maps.source.esSearch.topHitsSplitFieldLabel",{defaultMessage:"Entity"}),display:this.props.isColumnCompressed?"columnCompressed":"row"},(0,E.jsx)(F.R,{placeholder:d.i18n.translate("xpack.maps.source.esSearch.topHitsSplitFieldSelectPlaceholder",{defaultMessage:"Select entity field"}),value:this.props.topHitsSplitField,onChange:this._onTopHitsSplitFieldChange,fields:this.props.termFields,isClearable:!1,compressed:!0})),(this.props.topHitsSplitField||this.props.topHitsGroupByTimeseries)&&(0,E.jsx)(n().Fragment,null,(0,E.jsx)(f.EuiFormRow,{label:this.props.topHitsGroupByTimeseries?d.i18n.translate("xpack.maps.source.esSearch.topHitsTimeseriesSizeLabel",{defaultMessage:"Documents per time series"}):d.i18n.translate("xpack.maps.source.esSearch.topHitsSizeLabel",{defaultMessage:"Documents per entity"}),display:this.props.isColumnCompressed?"columnCompressed":"row"},(0,E.jsx)(k.U,{min:1,max:this.state.maxInnerResultWindow,step:1,value:this.props.topHitsSize,onChange:this._onTopHitsSizeChange,showLabels:!0,showInput:!0,showRange:!0,"data-test-subj":"layerPanelTopHitsSize",compressed:!0})),(0,E.jsx)(f.EuiFormRow,{label:d.i18n.translate("xpack.maps.source.esTopHitsSearch.sortFieldLabel",{defaultMessage:"Sort field"}),display:this.props.isColumnCompressed?"columnCompressed":"row"},(0,E.jsx)(F.R,{placeholder:d.i18n.translate("xpack.maps.source.esSearch.sortFieldSelectPlaceholder",{defaultMessage:"Select sort field"}),value:this.props.sortField,onChange:this._onSortFieldChange,fields:this.props.sortFields,compressed:!0})),(0,E.jsx)(f.EuiFormRow,{label:d.i18n.translate("xpack.maps.source.esTopHitsSearch.sortOrderLabel",{defaultMessage:"Sort order"}),display:this.props.isColumnCompressed?"columnCompressed":"row"},(0,E.jsx)(f.EuiSelect,{disabled:!this.props.sortField,options:[{text:d.i18n.translate("xpack.maps.source.esSearch.ascendingLabel",{defaultMessage:"ascending"}),value:S.SortDirection.asc},{text:d.i18n.translate("xpack.maps.source.esSearch.descendingLabel",{defaultMessage:"descending"}),value:S.SortDirection.desc}],value:this.props.sortOrder,onChange:this._onSortOrderChange,compressed:!0}))))}}class TopHitsUpdateSourceEditor extends l.Component{constructor(...e){super(...e),(0,a.default)(this,"_isMounted",!1),(0,a.default)(this,"state",{isLoading:!1,isTimeseries:!1,sourceFields:[],termFields:[],sortFields:[]}),(0,a.default)(this,"_onTooltipPropertiesChange",(e=>{this.props.onChange({propName:"tooltipProperties",value:e})})),(0,a.default)(this,"_onFilterByMapBoundsChange",(e=>{this.props.onChange({propName:"filterByMapBounds",value:e.target.checked})}))}componentDidMount(){this._isMounted=!0,this.loadFields()}componentWillUnmount(){this._isMounted=!1}async loadFields(){let e;this.setState({isLoading:!0});try{e=await(0,m.Mh)().get(this.props.indexPatternId)}catch(e){return void(this._isMounted&&this.setState({isLoading:!1,loadError:(0,y.vv)(this.props.indexPatternId)}))}if(!this._isMounted)return;const t=(0,w.pT)(e.fields).map((e=>new M.v({fieldName:e.name,source:this.props.source,origin:i.e$.SOURCE})));this.setState({isLoading:!1,isTimeseries:(0,w.Bb)(e),sourceFields:t,termFields:(0,w.r2)(e.fields),sortFields:(0,w.gs)(e.fields)})}render(){return(0,E.jsx)(l.Fragment,null,(0,E.jsx)(f.EuiPanel,null,(0,E.jsx)(f.EuiTitle,{size:"xs"},(0,E.jsx)("h5",null,(0,E.jsx)(_.FormattedMessage,{id:"xpack.maps.esSearch.tooltipsTitle",defaultMessage:"Tooltip fields"}))),(0,E.jsx)(f.EuiSpacer,{size:"m"}),(0,E.jsx)(f.EuiSkeletonText,{lines:3,size:"s",isLoading:this.state.isLoading},(0,E.jsx)(T.J,{tooltipFields:this.props.tooltipFields,onChange:this._onTooltipPropertiesChange,fields:this.state.sourceFields}))),(0,E.jsx)(f.EuiSpacer,{size:"s"}),(0,E.jsx)(f.EuiPanel,null,(0,E.jsx)(f.EuiTitle,{size:"xs"},(0,E.jsx)("h5",null,(0,E.jsx)(_.FormattedMessage,{id:"xpack.maps.source.topHitsPanelLabel",defaultMessage:"Top hits"}))),(0,E.jsx)(f.EuiSpacer,{size:"m"}),(0,E.jsx)(f.EuiSkeletonText,{lines:3,size:"s",isLoading:this.state.isLoading},(0,E.jsx)(TopHitsForm,{indexPatternId:this.props.indexPatternId,isColumnCompressed:!0,isTimeseries:this.state.isTimeseries,onChange:this.props.onChange,sortField:this.props.sortField,sortFields:this.state.sortFields,sortOrder:this.props.sortOrder,termFields:this.state.termFields,topHitsGroupByTimeseries:this.props.topHitsGroupByTimeseries,topHitsSplitField:this.props.topHitsSplitField,topHitsSize:this.props.topHitsSize})),(0,E.jsx)(f.EuiFormRow,null,(0,E.jsx)(f.EuiSwitch,{label:d.i18n.translate("xpack.maps.source.esSearch.extentFilterLabel",{defaultMessage:"Dynamically filter for data in the visible map area"}),checked:this.props.filterByMapBounds,onChange:this._onFilterByMapBoundsChange,compressed:!0}))),(0,E.jsx)(f.EuiSpacer,{size:"s"}))}}var N=s(89336),R=s(49229);class CreateSourceEditor extends l.Component{constructor(...e){super(...e),(0,a.default)(this,"state",{indexPattern:null,isTimeseries:!1,geoFields:[],geoFieldName:null,sortField:null,sortFields:[],sortOrder:S.SortDirection.desc,termFields:[],topHitsGroupByTimeseries:!1,topHitsSplitField:null,topHitsSize:1}),(0,a.default)(this,"_onIndexPatternSelect",(e=>{const t=(0,w.Th)(e.fields),s=(0,w.Bb)(e);this.setState({indexPattern:e,isTimeseries:s,geoFields:t,geoFieldName:t.length?t[0].name:null,sortField:e.timeFieldName?e.timeFieldName:null,sortFields:(0,w.gs)(e.fields),termFields:(0,w.r2)(e.fields),topHitsGroupByTimeseries:s,topHitsSplitField:null},this._previewLayer)})),(0,a.default)(this,"_onGeoFieldSelect",(e=>{this.setState({geoFieldName:e||null},this._previewLayer)})),(0,a.default)(this,"_onTopHitsPropChange",(({propName:e,value:t})=>{this.setState({[e]:t},this._previewLayer)})),(0,a.default)(this,"_previewLayer",(()=>{const{indexPattern:e,geoFieldName:t,sortField:s,sortOrder:a,topHitsGroupByTimeseries:o,topHitsSplitField:r,topHitsSize:l}=this.state,n=[];if(o){var d;const t=(null!==(d=null==e?void 0:e.fields)&&void 0!==d?d:[]).filter((e=>e.timeSeriesDimension)).map((e=>e.name));n.push(...t)}else r&&n.push(r);e&&e.timeFieldName&&n.push(e.timeFieldName);const p=t&&(null==e?void 0:e.getFieldByName(t)),c=e&&t&&s&&(o||r)?{indexPatternId:e.id,geoField:t,scalingType:i.wj.TOP_HITS,sortField:s,sortOrder:a,tooltipProperties:n,topHitsGroupByTimeseries:o,topHitsSplitField:r||void 0,topHitsSize:l}:null,u=!!p&&"geo_point"===p.type;this.props.onSourceConfigChange(c,u)}))}_renderGeoSelect(){return this.state.indexPattern?(0,E.jsx)(N.G,{value:this.state.geoFieldName?this.state.geoFieldName:"",onChange:this._onGeoFieldSelect,geoFields:this.state.geoFields}):null}_renderTopHitsPanel(){return this.state.indexPattern&&this.state.indexPattern.id&&this.state.geoFieldName?(0,E.jsx)(TopHitsForm,{indexPatternId:this.state.indexPattern.id,isColumnCompressed:!1,isTimeseries:this.state.isTimeseries,onChange:this._onTopHitsPropChange,sortField:this.state.sortField?this.state.sortField:"",sortFields:this.state.sortFields,sortOrder:this.state.sortOrder,termFields:this.state.termFields,topHitsGroupByTimeseries:this.state.topHitsGroupByTimeseries,topHitsSplitField:this.state.topHitsSplitField,topHitsSize:this.state.topHitsSize}):null}render(){return(0,E.jsx)(f.EuiPanel,null,(0,E.jsx)(R.k,{dataView:this.state.indexPattern,onChange:this._onIndexPatternSelect}),this._renderGeoSelect(),this._renderTopHitsPanel())}}var B=s(91557);const D={id:i.kI.ES_TOP_HITS,order:10,categories:[i.Jc.ELASTICSEARCH],description:d.i18n.translate("xpack.maps.source.topHitsDescription",{defaultMessage:"Display the most relevant documents per entity, e.g. the most recent GPS hits per vehicle."}),icon:()=>(0,E.jsx)("svg",{xmlns:"http://www.w3.org/2000/svg",width:"49",height:"25",fill:"none",viewBox:"0 0 49 25"},(0,E.jsx)("circle",{cx:"24.939",cy:"12.409",r:"2.182",className:"mapLayersWizardIcon__highlight"}),(0,E.jsx)("circle",{cx:"35.849",cy:"12.409",r:"2.182",className:"mapLayersWizardIcon__highlight"}),(0,E.jsx)("circle",{cx:"45.561",cy:"12.409",r:"3.273",className:"mapLayersWizardIcon__highlight"}),(0,E.jsx)("circle",{cx:"5.197",cy:"18.954",r:"2.182",className:"mapLayersWizardIcon__highlight"}),(0,E.jsx)("circle",{cx:"13.485",cy:"12.409",r:"2.182",className:"mapLayersWizardIcon__highlight"})),renderWizard:({previewLayers:e,mapColors:t})=>(0,E.jsx)(CreateSourceEditor,{onSourceConfigChange:(s,a)=>{if(!s)return void e([]);const o=ESSearchSource.createDescriptor(s),r=B.s$.createDescriptor({sourceDescriptor:o},t);a&&(r.style.properties[i.VM.LINE_WIDTH]={type:i.j4.STATIC,options:{size:0}}),e([r])}}),title:d.i18n.translate("xpack.maps.source.topHitsTitle",{defaultMessage:"Top hits per entity"})};function O(e,t,s){const i=[],a=[],o={};return t.forEach((t=>{const r=(0,x.VI)(e,t);if(r.scripted)o[r.name]={script:{source:r.script||"",lang:r.lang||""}};else if(r.readFromDocValues||r.runtimeField){const e="date"===r.type?{field:t,format:s}:t;i.push(e)}else a.push(t)})),{docValueFields:i,sourceOnlyFields:a,scriptFields:o}}var z=s(95079),W=s(65244),G=s(97337);function A(e){const t=(0,m.KI)().calculateBounds(e);return void 0!==t.min&&void 0!==t.max?{from:t.min.valueOf(),to:t.max.valueOf()}:void 0}const U=d.i18n.translate("xpack.maps.source.esSearchTitle",{defaultMessage:"Documents"});class ESSearchSource extends g.k8{static createDescriptor(e){const t=g.k8.createDescriptor(e);if(!(0,L.U)(t.geoField))throw new Error("Cannot create an ESSearchSourceDescriptor without a geoField");return{...t,type:i.m7.ES_SEARCH,geoField:t.geoField,filterByMapBounds:"boolean"!=typeof e.filterByMapBounds||e.filterByMapBounds,tooltipProperties:Array.isArray(e.tooltipProperties)?e.tooltipProperties:[],sortField:(0,L.U)(e.sortField)?e.sortField:"",sortOrder:(0,L.U)(e.sortOrder)?e.sortOrder:u.SortDirection.desc,scalingType:(0,L.U)(e.scalingType)?e.scalingType:i.wj.MVT,topHitsGroupByTimeseries:"boolean"==typeof t.topHitsGroupByTimeseries&&t.topHitsGroupByTimeseries,topHitsSplitField:(0,L.U)(e.topHitsSplitField)?e.topHitsSplitField:"",topHitsSize:"number"==typeof e.topHitsSize&&e.topHitsSize>0?e.topHitsSize:1}}constructor(e){const t=ESSearchSource.createDescriptor(e);super(t),(0,a.default)(this,"_descriptor",void 0),(0,a.default)(this,"_tooltipFields",void 0),this._descriptor=t,this._tooltipFields=this._descriptor.tooltipProperties?this._descriptor.tooltipProperties.map((e=>this.getFieldByName(e))):[]}renderSourceSettingsEditor(e){return this._isTopHits()?(0,E.jsx)(TopHitsUpdateSourceEditor,{source:this,indexPatternId:this.getIndexPatternId(),onChange:e.onChange,tooltipFields:this._tooltipFields,sortField:this._descriptor.sortField,sortOrder:this._descriptor.sortOrder,filterByMapBounds:this.isFilterByMapBounds(),topHitsGroupByTimeseries:this._descriptor.topHitsGroupByTimeseries,topHitsSplitField:this._descriptor.topHitsSplitField,topHitsSize:this._descriptor.topHitsSize}):(0,E.jsx)(UpdateSourceEditor,{source:this,indexPatternId:this.getIndexPatternId(),getGeoField:()=>this._getGeoField(),onChange:e.onChange,tooltipFields:this._tooltipFields,sortField:this._descriptor.sortField,sortOrder:this._descriptor.sortOrder,scalingType:this._descriptor.scalingType,filterByMapBounds:this.isFilterByMapBounds(),numberOfJoins:e.numberOfJoins,hasSpatialJoins:e.hasSpatialJoins})}async getFields(){try{return(await this.getIndexPattern()).fields.filter((e=>e.aggregatable)).map((e=>this.getFieldByName(e.name)))}catch(e){return[]}}getFieldByName(e){return new M.v({fieldName:e,source:this,origin:i.e$.SOURCE})}isMvt(){return this._descriptor.scalingType===i.wj.MVT}async getImmutableProperties(){let e="";try{e=(await this._getGeoField()).type}catch(e){}return[{label:(0,y.OS)(),value:U},{label:(0,y.EJ)(),value:await this.getDisplayName()},{label:d.i18n.translate("xpack.maps.source.esSearch.geoFieldLabel",{defaultMessage:"Geospatial field"}),value:this._descriptor.geoField},{label:d.i18n.translate("xpack.maps.source.esSearch.geoFieldTypeLabel",{defaultMessage:"Geospatial field type"}),value:e}]}_buildEsSort(){const{sortField:e,sortOrder:t}=this._descriptor;if(!e)throw new Error("Cannot build sort");return[{[e]:{order:t}}]}async _getTopHits(e,t,s,a){const{topHitsGroupByTimeseries:o,topHitsSplitField:l,topHitsSize:n}=this._descriptor;if(!o&&!l)throw new Error("Cannot _getTopHits without topHitsSplitField");const d=await this.getIndexPattern(),{docValueFields:c,sourceOnlyFields:u,scriptFields:h}=O(d,t.fieldNames,"epoch_millis"),g={size:n,script_fields:h,docvalue_fields:c,fields:[this._descriptor.geoField]};this._hasSort()&&(g.sort=this._buildEsSort()),0===u.length?g._source=!1:g._source={includes:u};const m={precision_threshold:1},f={size:i.vW,shard_size:i.vW},S=await this.makeSearchSource(t,0);if(S.setField("trackTotalHits",!1),o)S.setField("aggs",{totalEntities:{cardinality:{...m,field:"_tsid"}},entitySplit:{terms:{...f,field:"_tsid"},aggs:{entityHits:{top_hits:g}}}});else{const e=(0,x.VI)(d,l);if(S.setField("aggs",{totalEntities:{cardinality:(0,x.wd)(m,e)},entitySplit:{terms:(0,x.wd)(f,e),aggs:{entityHits:{top_hits:g}}}}),"string"===e.type){const t=(0,p.buildPhraseFilter)(e,"",d);t.meta.negate=!0,S.setField("filter",[...S.getField("filter"),t])}}const _=[],y=await this._runEsQuery({requestId:this.getId(),requestName:(0,I.z4)(e),searchSource:S,registerCancelCallback:s,searchSessionId:t.searchSessionId,executionContext:(0,W._)({description:"es_search_source:top_hits"},t.executionContext),requestsAdapter:a.requests,onWarning:e=>{_.push(e)}}),F=[],T=r().get(y,"aggregations.entitySplit.buckets",[]),w=r().get(y,"aggregations.totalEntities.value",0),M=T.length>=i.vW;let v=!1;return T.forEach((e=>{const t=r().get(e,"entityHits.hits.hits",[]);F.push(...t.slice().reverse()),(0,x.aS)(e.entityHits.hits.total,t.length)&&(v=!0)})),{hits:F,meta:{areResultsTrimmed:M||v,areEntitiesTrimmed:M,entityCount:T.length,totalEntities:w,warnings:_}}}async _getSearchHits(e,t,s,i){const a=[],o=await this.getIndexPattern(),{docValueFields:r,sourceOnlyFields:l}=O(o,t.fieldNames,"epoch_millis"),n={docvalue_fields:r},d={...t};delete d.timeslice;const p=void 0!==t.timeslice&&await this.canLoadAllDocuments(e,d,s,i,(e=>{a.push(e)})),c=await this.getMaxResultWindow(),u=await this.makeSearchSource(p?d:t,c,n);u.setField("trackTotalHits",c+1),u.setField("fieldsFromSource",t.fieldNames),0===l.length?u.setField("source",!1):u.setField("source",l),u.setField("fields",[this._descriptor.geoField]),this._hasSort()&&u.setField("sort",this._buildEsSort());const h=await this._runEsQuery({requestId:this.getId(),requestName:(0,I.z4)(e),searchSource:u,registerCancelCallback:s,searchSessionId:t.searchSessionId,executionContext:(0,W._)({description:"es_search_source:doc_search"},t.executionContext),requestsAdapter:i.requests,onWarning:e=>{a.push(e)}}),g=void 0!==t.timeslice&&!p;return{hits:h.hits.hits.slice().reverse(),meta:{resultsCount:h.hits.hits.length,areResultsTrimmed:(0,x.aS)(h.hits.total,h.hits.hits.length),timeExtent:g?t.timeslice:A(t.timeFilters),isTimeExtentForTimeslice:g,warnings:a}}}_isTopHits(){return this._descriptor.scalingType===i.wj.TOP_HITS}async _getSourceIndexList(){const e=await this.getIndexPattern();try{const{success:t,matchingIndexes:s}=await(async e=>await(0,m.PA)().fetch({path:i.rI,method:"GET",version:"1",query:{indexPattern:e}}))(e.getIndexPattern());return t?s:[]}catch(e){return[]}}async supportsFeatureEditing(){return 1===(await this._getSourceIndexList()).length}async _getNewFeatureFields(){if(!await this._isDrawingIndex())return{};const e=await(0,m.M1)().security.authc.getCurrentUser(),t=(new Date).toISOString();return{created:{...e?{user:e.username}:{},"@timestamp":t}}}async _isDrawingIndex(){const e=await this.getIndexPattern(),{success:t,isDrawingIndex:s}=await(async e=>await(0,m.PA)().fetch({path:i.Ic,method:"GET",version:"1",query:{index:e}}))(e.getIndexPattern());return t&&s}_hasSort(){const{sortField:e,sortOrder:t}=this._descriptor;return!!e&&!!t}async getMaxResultWindow(){const e=await this.getIndexPattern();return(await P(e.getIndexPattern())).maxResultWindow}isFieldAware(){return!0}getInspectorRequestIds(){return[this.getId(),this._getFeaturesCountRequestId()]}async getGeoJsonWithMeta(e,t,s,i,a){const o=await this.getIndexPattern(),{hits:r,meta:l}=this._isTopHits()?await this._getTopHits(e,t,s,a):await this._getSearchHits(e,t,s,a),n=o.metaFields.filter((e=>!["_id","_index"].includes(e))),p=e=>{const t=o.flattenHit(e);return n.forEach((e=>{delete t[e]})),t},c=t.fieldNames.filter((e=>{const t=(0,x.VI)(o,e);return t.readFromDocValues&&"date"===t.type}));let u;try{const e=await this._getGeoField();u=(0,x.xm)(r,p,e.name,e.type,c)}catch(e){throw new Error(d.i18n.translate("xpack.maps.source.esSearch.convertToGeoJsonErrorMsg",{defaultMessage:"Unable to convert search response to geoJson feature collection, error: {errorMsg}",values:{errorMsg:e.message}}))}return{data:u,meta:l}}hasTooltipProperties(){return this._tooltipFields.length>0}async _loadTooltipProperties(e,t,s,i){if(0===this._tooltipFields.length)return{};const a=(0,m.sI)(),o=await a.searchSource.create();o.setField("trackTotalHits",!1),o.setField("index",s),o.setField("size",1);const l={language:"kuery",query:`_id:"${e}" and _index:"${t}"`};o.setField("query",l),o.setField("fieldsFromSource",["_id"]),o.setField("source",!1),o.setField("fields",this._getTooltipPropertyNames().map((e=>{const t=s.fields.getByName(e);return t&&"date"===t.type?{field:e,format:"strict_date_optional_time"}:e})));const{rawResponse:n}=await(0,c.lastValueFrom)(o.fetch$({legacyHitsTotal:!1,executionContext:(0,W._)({description:"es_search_source:load_tooltip_properties"},i)})),p=r().get(n,"hits.hits[0]");if(!p)throw new Error(d.i18n.translate("xpack.maps.source.esSearch.loadTooltipPropertiesErrorMsg",{defaultMessage:"Unable to find document, _id: {docId}",values:{docId:e}}));const u=s.flattenHit(p);return s.metaFields.forEach((e=>{this._getTooltipPropertyNames().includes(e)||delete u[e]})),u}_getTooltipPropertyNames(){return this._tooltipFields.map((e=>e.getName()))}async getTooltipProperties(e,t){if(null===e)throw new Error("properties cannot be null");const s=await this.getIndexPattern(),i=await this._loadTooltipProperties(e._id,e._index,s,t),a=this._tooltipFields.map((e=>{const t=i[e.getName()];return e.createTooltipProperty(t)}));return Promise.all(a)}isFilterByMapBounds(){return this._descriptor.scalingType===i.wj.CLUSTERS||this._descriptor.scalingType!==i.wj.MVT&&!!this._descriptor.filterByMapBounds}async getLeftJoinFields(){const e=await this.getIndexPattern();return(0,w.pT)(e.fields).map((e=>this.getFieldByName(e.name)))}async getSupportedShapeTypes(){let e;try{e=(await this._getGeoField()).type}catch(e){}return e===i.pe.GEO_POINT?[i.HT.POINT]:[i.HT.POINT,i.HT.LINE,i.HT.POLYGON]}getSourceStatus(e){var t;const s=e?e.getMeta():null;return s?this._isTopHits()?{tooltipContent:`${s.areEntitiesTrimmed?d.i18n.translate("xpack.maps.esSearch.topHitsResultsTrimmedMsg",{defaultMessage:"Results limited to first {entityCount} entities of ~{totalEntities}.",values:{entityCount:null===(i=s.entityCount)||void 0===i?void 0:i.toLocaleString(),totalEntities:null===(a=s.totalEntities)||void 0===a?void 0:a.toLocaleString()}}):d.i18n.translate("xpack.maps.esSearch.topHitsEntitiesCountMsg",{defaultMessage:"Found {entityCount} entities.",values:{entityCount:null===(o=s.entityCount)||void 0===o?void 0:o.toLocaleString()}})} ${d.i18n.translate("xpack.maps.esSearch.topHitsSizeMsg",{defaultMessage:"Showing top {topHitsSize} documents per entity.",values:{topHitsSize:null===(r=this._descriptor.topHitsSize)||void 0===r?void 0:r.toLocaleString()}})}`,areResultsTrimmed:!!s.areEntitiesTrimmed}:s.areResultsTrimmed?{tooltipContent:d.i18n.translate("xpack.maps.esSearch.resultsTrimmedMsg",{defaultMessage:"Results limited to first {count} documents.",values:{count:null===(l=s.resultsCount)||void 0===l?void 0:l.toLocaleString()}}),areResultsTrimmed:!0}:{tooltipContent:d.i18n.translate("xpack.maps.esSearch.featureCountMsg",{defaultMessage:"Found {count} documents.",values:{count:null===(t=s.resultsCount)||void 0===t?void 0:t.toLocaleString()}}),areResultsTrimmed:!1}:{tooltipContent:null,areResultsTrimmed:!1};var i,a,o,r,l}getSyncMeta(){return{geoField:this._descriptor.geoField,filterByMapBounds:this._descriptor.filterByMapBounds,sortField:this._descriptor.sortField,sortOrder:this._descriptor.sortOrder,scalingType:this._descriptor.scalingType,topHitsGroupByTimeseries:this._descriptor.topHitsGroupByTimeseries,topHitsSplitField:this._descriptor.topHitsSplitField,topHitsSize:this._descriptor.topHitsSize}}async _getPreIndexedShape(e){if(null===e)return null;const t=await this._getGeoField();return{index:e._index,id:e._id,path:t.name}}supportsJoins(){return this._descriptor.scalingType!==i.wj.CLUSTERS}async _getEditableIndex(){const e=await this._getSourceIndexList();if(0===e.length)throw new Error(d.i18n.translate("xpack.maps.source.esSearch.indexZeroLengthEditError",{defaultMessage:"Your data view doesn't point to any indices."}));if(e.length>1)throw new Error(d.i18n.translate("xpack.maps.source.esSearch.indexOverOneLengthEditError",{defaultMessage:"Your data view points to multiple indices. Only one index is allowed per data view."}));return e[0]}async addFeature(e){const t=await this._getEditableIndex();await(async(e,t,s,a)=>{const o=(0,z.set)({...a},s,t);return await(0,m.PA)().fetch({path:`${i.Kg}`,method:"POST",version:"1",body:JSON.stringify({index:e,data:o})})})(t,e,this.getGeoFieldName(),await this._getNewFeatureFields())}async deleteFeature(e){const t=await this._getEditableIndex();await(async(e,t)=>await(0,m.PA)().fetch({path:`${i.Kg}/${t}`,method:"DELETE",version:"1",body:JSON.stringify({index:e})}))(t,e)}getTileSourceLayer(){return"hits"}async getTileUrl(e,t,s,a){const o=await this.getIndexPattern(),l=await P(o.getIndexPattern()),n=await this.makeSearchSource(e,l.maxResultWindow);return n.setField("fieldsFromSource",["_id"]),n.setField("source",!1),this._hasSort()&&n.setField("sort",this._buildEsSort()),n.setField("fields",e.fieldNames.map((e=>{const t=o.fields.getByName(e);return t&&"date"===t.type?{field:e,format:"epoch_millis"}:e}))),n.setField("filter",[...n.getField("filter"),(0,p.buildExistsFilter)({name:this._descriptor.geoField,type:"geo_point"},o)]),`${(0,m.PA)().basePath.prepend(`${i.uM}/{z}/{x}/{y}.pbf`)}?${(0,h.u)({geometryFieldName:this._descriptor.geoField,index:o.getIndexPattern(),hasLabels:s,buffer:a,requestBody:r().pick(n.getSearchRequestBody(),["fields","query","runtime_mappings","size","sort"]),token:t,executionContextId:(0,W.n)(e.executionContext)})}`}async getTimesliceMaskFieldName(){if(this._isTopHits()||this._descriptor.scalingType===i.wj.MVT)return null;try{const e=await this.getIndexPattern();return e.timeFieldName?e.timeFieldName:null}catch(e){return null}}getUpdateDueToTimeslice(e,t){if(this._isTopHits()||this._descriptor.scalingType===i.wj.MVT)return!0;if(void 0===e.timeExtent||void 0===e.areResultsTrimmed||e.areResultsTrimmed)return!0;const s=void 0!==e.isTimeExtentForTimeslice&&e.isTimeExtentForTimeslice;return t?!(!s||t.from>=e.timeExtent.from&&t.to<=e.timeExtent.to):!!s}_getFeaturesCountRequestId(){return this.getId()+"features_count"}async canLoadAllDocuments(e,t,s,i,a){const o=await this.getMaxResultWindow(),r=await this.makeSearchSource(t,0);r.setField("trackTotalHits",o+1);const l=await this._runEsQuery({requestId:this._getFeaturesCountRequestId(),requestName:d.i18n.translate("xpack.maps.vectorSource.featuresCountRequestName",{defaultMessage:"load features count ({layerName})",values:{layerName:e}}),searchSource:r,registerCancelCallback:s,searchSessionId:t.searchSessionId,executionContext:(0,W._)({description:"es_search_source:all_doc_counts"},t.executionContext),requestsAdapter:i.requests,onWarning:a});return!(0,x.aS)(l.hits.total,o)}getFeatureActions({addFilters:e,geoFieldNames:t,getActionContext:s,getFilterActions:a,mbFeature:o,onClose:r}){return 0===t.length||null===e?[]:o.geometry.type===i.K5.POLYGON||o.geometry.type===i.K5.MULTI_POLYGON?[{label:d.i18n.translate("xpack.maps.tooltip.action.filterByGeometryLabel",{defaultMessage:"Filter by geometry"}),id:"FILTER_BY_PRE_INDEXED_SHAPE_ACTION",form:(0,E.jsx)(G.f,{onClose:r,geoFieldNames:t,addFilters:e,getFilterActions:a,getActionContext:s,loadPreIndexedShape:async()=>this._getPreIndexedShape(o.properties)})}]:[]}}var V=s(56919);function J({indexPatternId:e,geoFieldName:t,geoFieldType:s,query:a}){const o=s===i.pe.GEO_POINT||s===i.pe.GEO_SHAPE&&(0,V.te)()?i.wj.CLUSTERS:i.wj.LIMIT,r=ESSearchSource.createDescriptor({indexPatternId:e,geoField:t,scalingType:o});return B.s$.createDescriptor({sourceDescriptor:r,query:a})}const q={indexPattern:void 0,geoFields:void 0,geoFieldName:void 0};class create_source_editor_CreateSourceEditor extends l.Component{constructor(...e){super(...e),(0,a.default)(this,"state",{...q}),(0,a.default)(this,"_onIndexPatternSelect",(e=>{const t=(0,w.Th)(e.fields);this.setState({...q,indexPattern:e,geoFields:t},(()=>{if(t.length){const e=t.find((e=>e.aggregatable))||t[0];this._onGeoFieldSelect(e.name)}}))})),(0,a.default)(this,"_onGeoFieldSelect",(e=>{this.setState({geoFieldName:e},this._previewLayer)})),(0,a.default)(this,"_previewLayer",(()=>{const{indexPattern:e,geoFieldName:t}=this.state,s=t&&(null==e?void 0:e.getFieldByName(t)),a=e&&t?{indexPatternId:e.id,geoField:t,scalingType:i.wj.MVT}:null,o=!!s&&"geo_point"===s.type;this.props.onSourceConfigChange(a,o)}))}_renderGeoSelect(){if(this.state.indexPattern)return(0,E.jsx)(f.EuiFormRow,{label:d.i18n.translate("xpack.maps.source.esSearch.geofieldLabel",{defaultMessage:"Geospatial field"})},(0,E.jsx)(F.R,{placeholder:d.i18n.translate("xpack.maps.source.esSearch.selectLabel",{defaultMessage:"Select geo field"}),value:this.state.geoFieldName?this.state.geoFieldName:null,onChange:this._onGeoFieldSelect,fields:this.state.geoFields}))}render(){return(0,E.jsx)(f.EuiPanel,null,(0,E.jsx)(R.k,{dataView:this.state.indexPattern,onChange:this._onIndexPatternSelect}),this._renderGeoSelect())}}var $=s(70508);function Y(e,t){const s=ESSearchSource.createDescriptor(e);return s.scalingType===i.wj.CLUSTERS?B.z8.createDescriptor({sourceDescriptor:s},t):s.scalingType===i.wj.MVT?B.YQ.createDescriptor({sourceDescriptor:s},t):B.s$.createDescriptor({sourceDescriptor:s},t)}const K={id:i.kI.ES_DOCUMENT,order:10,categories:[i.Jc.ELASTICSEARCH],description:d.i18n.translate("xpack.maps.source.esSearchDescription",{defaultMessage:"Points, lines, and polygons from Elasticsearch"}),icon:$.l,renderWizard:({previewLayers:e,mapColors:t})=>(0,E.jsx)(create_source_editor_CreateSourceEditor,{onSourceConfigChange:(s,a)=>{if(!s)return void e([]);const o=Y(s,t);a&&(o.style.properties[i.VM.LINE_WIDTH]={type:i.j4.STATIC,options:{size:0}}),e([o])}}),title:U}},89336:(e,t,s)=>{s.d(t,{G:()=>n});var i=s(3185),a=(s(84286),s(75008)),o=s(81319),r=s(52141),l=s(96791);function n(e){const{geoFields:t,...s}=e;return(0,l.jsx)(o.EuiFormRow,{label:a.i18n.translate("xpack.maps.source.geofieldLabel",{defaultMessage:"Geospatial field"})},(0,l.jsx)(r.R,(0,i.default)({placeholder:a.i18n.translate("xpack.maps.source.selectLabel",{defaultMessage:"Select geo field"}),fields:e.geoFields},s)))}},49229:(e,t,s)=>{s.d(t,{k:()=>g});var i=s(84286),a=s.n(i),o=s(59812),r=s(81319),l=s(75008),n=s(75879),d=s(14627),p=s(99723),c=s(80055),u=s(22787),h=s(96791);function g(e){var t;const[s,g]=(0,i.useState)(!1),m=(0,i.useMemo)((()=>!!e.dataView&&e.dataView.fields.some((t=>!d.indexPatterns.isNestedField(t)&&null!=e&&e.isGeoPointsOnly?u.pe.GEO_POINT===t.type:u.Qo.includes(t.type)))),[e.dataView,null==e?void 0:e.isGeoPointsOnly]),x=(0,o.default)(),f=(0,i.useRef)(),S=(0,p.wb)(),_=!!e.dataView&&!m,y=_?l.i18n.translate("xpack.maps.noGeoFieldInIndexPattern.message",{defaultMessage:"Data view does not contain any geospatial fields"}):"";return(0,h.jsx)(a().Fragment,null,s?(0,h.jsx)(a().Fragment,null,(0,h.jsx)(r.EuiCallOut,{title:l.i18n.translate("xpack.maps.noIndexPattern.messageTitle",{defaultMessage:"Couldn't find any data views"}),color:"warning"},(0,h.jsx)("p",null,(0,h.jsx)(n.FormattedMessage,{id:"xpack.maps.noIndexPattern.doThisPrefixDescription",defaultMessage:"You'll need to "}),(0,h.jsx)(r.EuiLink,{href:(0,p.PA)().basePath.prepend("/app/management/kibana/dataViews")},(0,h.jsx)(n.FormattedMessage,{id:"xpack.maps.noIndexPattern.doThisLinkTextDescription",defaultMessage:"Create a data view."}))),(0,h.jsx)("p",null,(0,h.jsx)(n.FormattedMessage,{id:"xpack.maps.noIndexPattern.hintDescription",defaultMessage:"Don't have any data? "}),(0,h.jsx)(r.EuiLink,{href:(0,p.PA)().basePath.prepend("/app/home#/tutorial_directory/sampleData")},(0,h.jsx)(n.FormattedMessage,{id:"xpack.maps.noIndexPattern.getStartedLinkText",defaultMessage:"Get started with some sample data sets."})))),(0,h.jsx)(r.EuiSpacer,{size:"s"})):null,(0,h.jsx)(r.EuiFormRow,{label:(0,c.EJ)(),isInvalid:_,error:y},(0,h.jsx)(S,{isInvalid:_,isDisabled:s,indexPatternId:null!==(t=e.dataView)&&void 0!==t&&t.id?e.dataView.id:"",onChange:async function(t){if(!t||0===t.length)return;let s;f.current=t;try{s=await(0,p.Mh)().get(t)}catch(e){return}x()&&s.id===f.current&&e.onChange(s)},placeholder:(0,c.B$)(),onNoIndexPatterns:()=>{g(!0)},isClearable:!1,"data-test-subj":"mapGeoIndexPatternSelect"})))}},18708:(e,t,s)=>{s.d(t,{J:()=>TooltipSelector});var i=s(3185),a=s(68915),o=s(84286),r=s(65927),l=s.n(r),n=s(81319),d=s(75879),p=s(75008),c=s(31936),u=s(52545),h=s(96791);function g(e,t){return e.label.localeCompare(t.label)}class AddTooltipFieldPopover extends o.Component{constructor(...e){super(...e),(0,a.default)(this,"state",{isPopoverOpen:!1,checkedFields:[]}),(0,a.default)(this,"_togglePopover",(()=>{this.setState((e=>({isPopoverOpen:!e.isPopoverOpen})))})),(0,a.default)(this,"_closePopover",(()=>{this.setState({isPopoverOpen:!1})})),(0,a.default)(this,"_onSelect",(e=>{const t=e.filter((e=>"on"===e.checked)).map((e=>e.value));this.setState({checkedFields:t,options:e})})),(0,a.default)(this,"_onAdd",(()=>{this.props.onAdd(this.state.checkedFields),this.setState({checkedFields:[]}),this._closePopover()}))}static getDerivedStateFromProps(e,t){return e.fields!==t.prevFields||e.selectedFields!==t.prevSelectedFields?{options:(s=e.fields,i=e.selectedFields,s?s.filter((e=>!i.find((t=>e.name===t.name)))).map((e=>({value:e.name,name:e.name,prepend:"type"in e?(0,h.jsx)(c.q,{className:"eui-alignMiddle",type:e.type,fill:"none"}):null,label:e.label}))).sort(g):[]),checkedFields:[],prevFields:e.fields,prevSelectedFields:e.selectedFields}:null;var s,i}_renderAddButton(){return(0,h.jsx)(n.EuiButtonEmpty,{onClick:this._togglePopover,size:"xs",iconType:"plusInCircleFilled",isDisabled:!this.props.fields},(0,h.jsx)(d.FormattedMessage,{id:"xpack.maps.tooltipSelector.togglePopoverLabel",defaultMessage:"Add"}))}_renderContent(){const e=0===this.state.checkedFields.length?p.i18n.translate("xpack.maps.tooltipSelector.addLabelWithoutCount",{defaultMessage:"Add"}):p.i18n.translate("xpack.maps.tooltipSelector.addLabelWithCount",{defaultMessage:"Add {count}",values:{count:this.state.checkedFields.length}});return(0,h.jsx)(o.Fragment,null,(0,h.jsx)(n.EuiSelectable,{searchable:!0,searchProps:{compressed:!0},options:this.state.options,onChange:this._onSelect,optionMatcher:u.$K},((e,t)=>(0,h.jsx)("div",{style:{width:"300px"}},(0,h.jsx)(n.EuiPopoverTitle,{paddingSize:"s"},t),e))),(0,h.jsx)(n.EuiSpacer,{size:"xs"}),(0,h.jsx)(n.EuiPopoverFooter,{paddingSize:"s"},(0,h.jsx)(n.EuiTextAlign,{textAlign:"right"},(0,h.jsx)(n.EuiButton,{fill:!0,isDisabled:0===this.state.checkedFields.length,onClick:this._onAdd,size:"s"},e))))}render(){return(0,h.jsx)(n.EuiPopover,{id:"addTooltipFieldPopover",anchorPosition:"leftCenter",button:this._renderAddButton(),isOpen:this.state.isPopoverOpen,closePopover:this._closePopover,panelPaddingSize:"none",ownFocus:!0},this._renderContent())}}async function m(e){return{label:await e.getLabel(),type:await e.getDataType(),name:e.getName()}}class TooltipSelector extends o.Component{constructor(e){super(e),(0,a.default)(this,"_isMounted",void 0),(0,a.default)(this,"_previousFields",void 0),(0,a.default)(this,"_previousSelectedTooltips",void 0),(0,a.default)(this,"state",{fieldProps:[],selectedFieldProps:[]}),(0,a.default)(this,"_getPropertyLabel",(e=>{if(!this.state.fieldProps.length)return e;const t=this.state.fieldProps.find((t=>t.name===e));return t?t.label:e})),(0,a.default)(this,"_onAdd",(e=>{if(this.props.tooltipFields){const t=this._getTooltipFieldNames();this.props.onChange([...t,...e])}else this.props.onChange([...e])})),(0,a.default)(this,"_removeProperty",(e=>{if(this.props.tooltipFields){const t=this._getTooltipFieldNames();t.splice(e,1),this.props.onChange(t)}else this.props.onChange([])})),(0,a.default)(this,"_onDragEnd",(({source:e,destination:t})=>{t&&this.props.onChange(((e,t,s)=>{const i=Array.from(e),[a]=i.splice(t,1);return i.splice(s,0,a),i})(this._getTooltipFieldNames(),e.index,t.index))})),this._isMounted=!1,this._previousFields=null,this._previousSelectedTooltips=null}componentDidMount(){this._isMounted=!0,this._loadFieldProps(),this._loadTooltipFieldProps()}componentWillUnmount(){this._isMounted=!1}componentDidUpdate(){this._loadTooltipFieldProps(),this._loadFieldProps()}async _loadTooltipFieldProps(){if(!this.props.tooltipFields||this.props.tooltipFields===this._previousSelectedTooltips)return;this._previousSelectedTooltips=this.props.tooltipFields;const e=this.props.tooltipFields.map(m),t=await Promise.all(e);this._isMounted&&this.setState({selectedFieldProps:t})}async _loadFieldProps(){if(!this.props.fields||this.props.fields===this._previousFields)return;this._previousFields=this.props.fields;const e=this.props.fields.map(m),t=await Promise.all(e);this._isMounted&&this.setState({fieldProps:t})}_getTooltipFieldNames(){return this.props.tooltipFields?this.props.tooltipFields.map((e=>e.getName())):[]}_renderProperties(){return this.state.selectedFieldProps.length?(0,h.jsx)(n.EuiDragDropContext,{onDragEnd:this._onDragEnd},(0,h.jsx)(n.EuiDroppable,{droppableId:"mapLayerTOC",spacing:"none"},((e,t)=>(0,h.jsx)(o.Fragment,null,this.state.selectedFieldProps.map(((e,s)=>(0,h.jsx)(n.EuiDraggable,{spacing:"none",key:e.name,index:s,draggableId:e.name,customDragHandle:!0,disableInteractiveElementBlocking:!0},((a,o)=>(0,h.jsx)("div",{className:l()("mapTooltipSelector__propertyRow",{"mapTooltipSelector__propertyRow-isDragging":o.isDragging,"mapTooltipSelector__propertyRow-isDraggingOver":t.isDraggingOver})},(0,h.jsx)(n.EuiText,{className:"mapTooltipSelector__propertyContent",size:"s"},this._getPropertyLabel(e.name)),(0,h.jsx)("div",{className:"mapTooltipSelector__propertyIcons"},(0,h.jsx)(n.EuiButtonIcon,{iconType:"trash",color:"danger",onClick:this._removeProperty.bind(null,s),title:p.i18n.translate("xpack.maps.tooltipSelector.trashButtonTitle",{defaultMessage:"Remove property"}),"aria-label":p.i18n.translate("xpack.maps.tooltipSelector.trashButtonAriaLabel",{defaultMessage:"Remove property"})}),(0,h.jsx)(n.EuiButtonIcon,(0,i.default)({className:"mapTooltipSelector__grab",iconType:"grab",color:"text",title:p.i18n.translate("xpack.maps.tooltipSelector.grabButtonTitle",{defaultMessage:"Reorder property"}),"aria-label":p.i18n.translate("xpack.maps.tooltipSelector.grabButtonAriaLabel",{defaultMessage:"Reorder property"})},a.dragHandleProps)))))))))))):(0,h.jsx)(n.EuiText,{size:"s",textAlign:"center"},(0,h.jsx)("p",null,(0,h.jsx)(n.EuiTextColor,{color:"subdued"},(0,h.jsx)(d.FormattedMessage,{id:"xpack.maps.tooltipSelector.emptyState.description",defaultMessage:"Add a tooltip field to create filters from field values."}))))}render(){return(0,h.jsx)("div",null,this._renderProperties(),(0,h.jsx)(n.EuiSpacer,{size:"s"}),(0,h.jsx)(n.EuiTextAlign,{textAlign:"center"},(0,h.jsx)(AddTooltipFieldPopover,{onAdd:this._onAdd,fields:this.state.fieldProps,selectedFields:this.state.selectedFieldProps})))}}},59812:(e,t,s)=>{Object.defineProperty(t,"__esModule",{value:!0});var i=s(84286);t.default=function(){var e=i.useRef(!1),t=i.useCallback((function(){return e.current}),[]);return i.useEffect((function(){return e.current=!0,function(){e.current=!1}}),[]),t}}}]);