"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.startAppStateSyncing = startAppStateSyncing;
var _rxjs = require("rxjs");
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _kibana_services = require("../../../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function startAppStateSyncing(appStateManager, kbnUrlStateStorage) {
  // get appStateContainer
  // sync app filters with app state container from data.query to state container
  const {
    query
  } = (0, _kibana_services.getData)();

  // Filter manager state persists across applications
  // clear app state filters to prevent application filters from other applications being transfered to maps
  query.filterManager.setAppFilters([]);
  const stateContainer = {
    get: () => ({
      query: appStateManager.getQuery(),
      filters: appStateManager.getFilters()
    }),
    set: state => state && appStateManager.setQueryAndFilters({
      query: state.query,
      filters: state.filters
    }),
    state$: appStateManager._updated$.pipe((0, _rxjs.map)(() => ({
      query: appStateManager.getQuery(),
      filters: appStateManager.getFilters()
    })))
  };
  const stopSyncingQueryAppStateWithStateContainer = (0, _public.connectToQueryState)(query, stateContainer, {
    filters: _esQuery.FilterStateStore.APP_STATE,
    query: true
  });

  // sets up syncing app state container with url
  const {
    start: startSyncingAppStateWithUrl,
    stop: stopSyncingAppStateWithUrl
  } = (0, _public2.syncState)({
    storageKey: '_a',
    stateStorage: kbnUrlStateStorage,
    stateContainer
  });

  // merge initial state from app state container and current state in url
  const initialAppState = {
    ...stateContainer.get(),
    // @ts-ignore
    ...kbnUrlStateStorage.get('_a')
  };
  // trigger state update. actually needed in case some data was in url
  stateContainer.set(initialAppState);

  // set current url to whatever is in app state container
  kbnUrlStateStorage.set('_a', initialAppState, {
    replace: true
  });

  // finally start syncing state containers with url
  startSyncingAppStateWithUrl();
  return () => {
    stopSyncingQueryAppStateWithStateContainer();
    stopSyncingAppStateWithUrl();
  };
}