"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewInMaps = ViewInMaps;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ViewInMaps(props) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "deprecatedVisInfo",
    size: "s",
    title: _i18n.i18n.translate('xpack.maps.legacyVisualizations.title', {
      defaultMessage: '{label} has transitioned to Maps.',
      values: {
        label: props.visualizationLabel
      }
    })
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.legacyVisualizations.editMessage",
    defaultMessage: "Maps has replaced {label}. To edit, convert to Maps.",
    values: {
      label: props.visualizationLabel
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.legacyVisualizations.useMapsMsg",
    defaultMessage: "With Maps, you can add multiple layers and indices, plot individual documents, symbolize features from data values, add heatmaps, grids, and clusters, and more."
  })), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: props.onClick,
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.legacyVisualizations.openInMapsButtonLabel",
    defaultMessage: "View in Maps"
  }))));
}