"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TileErrorCache = void 0;
exports.getErrorCacheTileKey = getErrorCacheTileKey;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _geo_tile_utils = require("../../../classes/util/geo_tile_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getErrorCacheTileKey(canonical) {
  return `${canonical.z}/${canonical.x}/${canonical.y}`;
}
class TileErrorCache {
  constructor() {
    (0, _defineProperty2.default)(this, "_cache", {});
  }
  clearLayer(layerId, onClear) {
    if (!(layerId in this._cache)) {
      return;
    }
    delete this._cache[layerId];
    onClear();
  }
  clearTileError(layerId, tileKey, onClear) {
    if (!layerId || !(layerId in this._cache)) {
      return;
    }
    const tileErrors = this._cache[layerId];
    if (!(tileKey in tileErrors)) {
      return;
    }
    delete tileErrors[tileKey];
    this._cache[layerId] = tileErrors;
    onClear();
  }
  hasAny() {
    return Object.keys(this._cache).some(layerId => {
      return Object.keys(this._cache[layerId]).length;
    });
  }
  hasTileError(layerId, tileKey) {
    return layerId in this._cache ? tileKey in this._cache[layerId] : false;
  }
  setTileError(layerId, tileError) {
    const tileErrors = this._cache[layerId] ? this._cache[layerId] : {};
    tileErrors[tileError.tileKey] = tileError;
    this._cache[layerId] = tileErrors;
  }
  getInViewTileErrors(layerId, zoom, extent) {
    const tileErrors = this._cache[layerId];
    if (!tileErrors) {
      return;
    }
    const tileErrorsArray = Object.values(tileErrors);
    if (!tileErrorsArray.length) {
      return;
    }
    const inViewTileKeys = (0, _geo_tile_utils.getTilesForExtent)(zoom, extent).map(getErrorCacheTileKey);
    const inViewTileErrors = tileErrorsArray.filter(tileError => {
      return inViewTileKeys.includes(tileError.tileKey);
    });
    return inViewTileErrors.length ? inViewTileErrors : undefined;
  }
}
exports.TileErrorCache = TileErrorCache;