"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StaticOrientationProperty = void 0;
var _static_style_property = require("./static_style_property");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class StaticOrientationProperty extends _static_style_property.StaticStyleProperty {
  constructor(options, styleName) {
    if (typeof options.orientation !== 'number') {
      super({
        orientation: 0
      }, styleName);
    } else {
      super(options, styleName);
    }
  }
  syncIconRotationWithMb(symbolLayerId, mbMap) {
    mbMap.setLayoutProperty(symbolLayerId, 'icon-rotate', this._options.orientation);
  }
}
exports.StaticOrientationProperty = StaticOrientationProperty;