"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DynamicTextProperty = void 0;
var _i18n = require("@kbn/i18n");
var _dynamic_style_property = require("./dynamic_style_property");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DynamicTextProperty extends _dynamic_style_property.DynamicStyleProperty {
  syncTextFieldWithMb(mbLayerId, mbMap) {
    if (this._field && this._field.isValid()) {
      const targetName = this.getMbPropertyName();
      if (this._field.isCount()) {
        mbMap.setLayoutProperty(mbLayerId, 'text-field', ['number-format', [this.getMbLookupFunction(), targetName], {
          locale: _i18n.i18n.getLocale()
        }]);
      } else {
        mbMap.setLayoutProperty(mbLayerId, 'text-field', ['coalesce', [this.getMbLookupFunction(), targetName], '']);
      }
    } else {
      if (typeof mbMap.getLayoutProperty(mbLayerId, 'text-field') !== 'undefined') {
        mbMap.setLayoutProperty(mbLayerId, 'text-field', undefined);
      }
    }
  }
  isOrdinal() {
    return false;
  }
  supportsFieldMeta() {
    return false;
  }
  supportsFeatureState() {
    return false;
  }
  getMbPropertyValue(rawValue) {
    return this.formatField(rawValue);
  }
}
exports.DynamicTextProperty = DynamicTextProperty;