"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DynamicOrientationForm = DynamicOrientationForm;
var _react = _interopRequireDefault(require("react"));
var _field_select = require("../field_select");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DynamicOrientationForm({
  fields,
  onDynamicStyleChange,
  staticDynamicSelect,
  styleProperty
}) {
  const styleOptions = styleProperty.getOptions();
  const onFieldChange = ({
    field
  }) => {
    onDynamicStyleChange(styleProperty.getStyleName(), {
      ...styleOptions,
      field
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "mapStyleSettings__fixedBox"
  }, staticDynamicSelect), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_field_select.FieldSelect, {
    styleName: styleProperty.getStyleName(),
    fields: fields,
    selectedFieldName: styleProperty.getFieldName(),
    onChange: onFieldChange,
    compressed: true
  })));
}