"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorGradient = void 0;
var _react = _interopRequireDefault(require("react"));
var _color_palettes = require("../../../color_palettes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ColorGradient = ({
  colorPaletteId
}) => {
  const palette = (0, _color_palettes.getColorPalette)(colorPaletteId);
  return palette.length ? /*#__PURE__*/_react.default.createElement("div", {
    className: "mapColorGradient",
    style: {
      background: (0, _color_palettes.getLinearGradient)(palette)
    }
  }) : null;
};
exports.ColorGradient = ColorGradient;