"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sourceTitle = exports.WMSSource = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _source = require("../source");
var _i18n_getters = require("../../../../common/i18n_getters");
var _wms_client = require("./wms_client");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-ignore

const sourceTitle = exports.sourceTitle = _i18n.i18n.translate('xpack.maps.source.wmsTitle', {
  defaultMessage: 'Web Map Service'
});
class WMSSource extends _source.AbstractSource {
  static createDescriptor({
    serviceUrl,
    layers,
    styles
  }) {
    return {
      type: WMSSource.type,
      serviceUrl,
      layers,
      styles
    };
  }
  constructor(sourceDescriptor) {
    super(sourceDescriptor);
    (0, _defineProperty2.default)(this, "_descriptor", void 0);
    this._descriptor = sourceDescriptor;
  }
  async hasLegendDetails() {
    return false;
  }
  renderLegendDetails() {
    return null;
  }
  isSourceStale(mbSource, sourceData) {
    var _mbSource$tiles;
    if (!sourceData.url) {
      return false;
    }
    return ((_mbSource$tiles = mbSource.tiles) === null || _mbSource$tiles === void 0 ? void 0 : _mbSource$tiles[0]) !== sourceData.url;
  }
  async canSkipSourceUpdate() {
    return false;
  }
  async getImmutableProperties() {
    return [{
      label: (0, _i18n_getters.getDataSourceLabel)(),
      value: sourceTitle
    }, {
      label: (0, _i18n_getters.getUrlLabel)(),
      value: this._descriptor.serviceUrl
    }, {
      label: _i18n.i18n.translate('xpack.maps.source.wms.layersLabel', {
        defaultMessage: 'Layers'
      }),
      value: this._descriptor.layers
    }, {
      label: _i18n.i18n.translate('xpack.maps.source.wms.stylesLabel', {
        defaultMessage: 'Styles'
      }),
      value: this._descriptor.styles
    }];
  }
  async getDisplayName() {
    return this._descriptor.serviceUrl;
  }
  async getUrlTemplate() {
    const client = new _wms_client.WmsClient({
      serviceUrl: this._descriptor.serviceUrl
    });
    return client.getUrlTemplate(this._descriptor.layers, this._descriptor.styles || '');
  }
}
exports.WMSSource = WMSSource;
(0, _defineProperty2.default)(WMSSource, "type", _constants.SOURCE_TYPES.WMS);