"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSourceByType = getSourceByType;
exports.registerSource = registerSource;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable @typescript-eslint/consistent-type-definitions */

const registry = [];
function registerSource(entry) {
  const sourceTypeExists = registry.some(({
    type
  }) => {
    return entry.type === type;
  });
  if (sourceTypeExists) {
    throw new Error(`Unable to register source type ${entry.type}. ${entry.type} has already been registered`);
  }
  registry.push(entry);
}
function getSourceByType(sourceType) {
  return registry.find(source => source.type === sourceType);
}