"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MVTField = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _field = require("./field");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class MVTField extends _field.AbstractField {
  constructor({
    fieldName,
    type,
    source,
    origin
  }) {
    super({
      fieldName,
      origin
    });
    (0, _defineProperty2.default)(this, "_source", void 0);
    (0, _defineProperty2.default)(this, "_type", void 0);
    this._source = source;
    this._type = type;
  }
  supportsFieldMetaFromEs() {
    return false;
  }
  supportsFieldMetaFromLocalData() {
    return false;
  }
  getMVTFieldDescriptor() {
    return {
      type: this._type,
      name: this.getName()
    };
  }
  getSource() {
    return this._source;
  }
  async getDataType() {
    if (this._type === _constants.MVT_FIELD_TYPE.STRING) {
      return 'string';
    } else if (this._type === _constants.MVT_FIELD_TYPE.NUMBER) {
      return 'number';
    } else {
      throw new Error(`Unrecognized MVT field-type ${this._type}`);
    }
  }
  async getLabel() {
    return this.getName();
  }
}
exports.MVTField = MVTField;