"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagementLandingPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _managementCardsNavigation = require("@kbn/management-cards-navigation");
var _management_context = require("../management_app/management_context");
var _classic_empty_prompt = require("./classic_empty_prompt");
var _solution_empty_prompt = require("./solution_empty_prompt");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ManagementLandingPage = ({
  setBreadcrumbs,
  onAppMounted
}) => {
  const {
    appBasePath,
    sections,
    kibanaVersion,
    cardsNavigationConfig,
    chromeStyle,
    coreStart
  } = (0, _management_context.useAppContext)();
  setBreadcrumbs();
  (0, _react.useEffect)(() => {
    onAppMounted('');
  }, [onAppMounted]);
  if (cardsNavigationConfig !== null && cardsNavigationConfig !== void 0 && cardsNavigationConfig.enabled) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
      restrictWidth: true,
      "data-test-subj": "cards-navigation-page"
    }, /*#__PURE__*/_react.default.createElement(_managementCardsNavigation.CardsNavigation, {
      sections: sections,
      appBasePath: appBasePath,
      hideLinksTo: cardsNavigationConfig === null || cardsNavigationConfig === void 0 ? void 0 : cardsNavigationConfig.hideLinksTo,
      extendedCardNavigationDefinitions: cardsNavigationConfig === null || cardsNavigationConfig === void 0 ? void 0 : cardsNavigationConfig.extendCardNavDefinitions
    }));
  }
  if (!chromeStyle) return null;
  if (chromeStyle === 'project') {
    return /*#__PURE__*/_react.default.createElement(_solution_empty_prompt.SolutionEmptyPrompt, {
      kibanaVersion: kibanaVersion,
      coreStart: coreStart
    });
  }
  return /*#__PURE__*/_react.default.createElement(_classic_empty_prompt.ClassicEmptyPrompt, {
    kibanaVersion: kibanaVersion
  });
};
exports.ManagementLandingPage = ManagementLandingPage;