"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogViewsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _log_views = require("../../../common/log_views");
var _log_views_client = require("./log_views_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class LogViewsService {
  constructor(logger) {
    (0, _defineProperty2.default)(this, "internalLogViews", new Map());
    (0, _defineProperty2.default)(this, "logViewFallbackHandler", null);
    (0, _defineProperty2.default)(this, "logViewsStaticConfig", _log_views.defaultLogViewsStaticConfig);
    this.logger = logger;
  }
  setup() {
    const {
      internalLogViews
    } = this;
    return {
      defineInternalLogView: (logViewId, logViewAttributes) => {
        internalLogViews.set(logViewId, {
          id: logViewId,
          origin: 'internal',
          attributes: {
            ..._log_views.defaultLogViewAttributes,
            ...logViewAttributes
          },
          updatedAt: Date.now()
        });
      },
      registerLogViewFallbackHandler: handler => {
        this.logViewFallbackHandler = handler;
      },
      setLogViewsStaticConfig: config => {
        this.logViewsStaticConfig = config;
      }
    };
  }
  start({
    dataViews,
    logsDataAccess,
    elasticsearch,
    savedObjects
  }) {
    const {
      internalLogViews,
      logger,
      logViewFallbackHandler,
      logViewsStaticConfig
    } = this;
    return {
      getClient(savedObjectsClient, elasticsearchClient, logSourcesService, request) {
        return new _log_views_client.LogViewsClient(logger, dataViews.dataViewsServiceFactory(savedObjectsClient, elasticsearchClient, request), logSourcesService, savedObjectsClient, logViewFallbackHandler, internalLogViews, logViewsStaticConfig);
      },
      getScopedClient(request) {
        const savedObjectsClient = savedObjects.getScopedClient(request);
        const elasticsearchClient = elasticsearch.client.asScoped(request).asCurrentUser;
        const logSourcesService = logsDataAccess.services.logSourcesServiceFactory.getScopedLogSourcesService(request);
        return this.getClient(savedObjectsClient, elasticsearchClient, logSourcesService, request);
      }
    };
  }
}
exports.LogViewsService = LogViewsService;