"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataSearchResponseState = void 0;
var _react = require("react");
var _use_observable = require("../use_observable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDataSearchResponseState = response$ => {
  var _latestValue$response, _latestValue$response2;
  const {
    latestValue
  } = (0, _use_observable.useObservableState)(response$, undefined);
  const cancelRequest = (0, _react.useCallback)(() => {
    latestValue === null || latestValue === void 0 ? void 0 : latestValue.abortController.abort();
  }, [latestValue]);
  return {
    cancelRequest,
    isRequestRunning: (_latestValue$response = latestValue === null || latestValue === void 0 ? void 0 : latestValue.response.isRunning) !== null && _latestValue$response !== void 0 ? _latestValue$response : false,
    isResponsePartial: (_latestValue$response2 = latestValue === null || latestValue === void 0 ? void 0 : latestValue.response.isPartial) !== null && _latestValue$response2 !== void 0 ? _latestValue$response2 : false,
    latestResponseData: latestValue === null || latestValue === void 0 ? void 0 : latestValue.response.data,
    latestResponseErrors: latestValue === null || latestValue === void 0 ? void 0 : latestValue.response.errors,
    loaded: latestValue === null || latestValue === void 0 ? void 0 : latestValue.response.loaded,
    total: latestValue === null || latestValue === void 0 ? void 0 : latestValue.response.total
  };
};
exports.useDataSearchResponseState = useDataSearchResponseState;