"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.WithSummary = void 0;
var _useThrottle = _interopRequireDefault(require("react-use/lib/useThrottle"));
var _ = require("../../..");
var _log_summary = require("./log_summary");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FETCH_THROTTLE_INTERVAL = 3000;
const WithSummary = ({
  serializedParsedQuery,
  children
}) => {
  const {
    logViewReference
  } = (0, _.useLogViewContext)();
  const {
    startTimestamp,
    endTimestamp
  } = (0, _.useLogPositionStateContext)();

  // Keep it reasonably updated for the `now` case, but don't reload all the time when the user scrolls
  const throttledStartTimestamp = (0, _useThrottle.default)(startTimestamp, FETCH_THROTTLE_INTERVAL);
  const throttledEndTimestamp = (0, _useThrottle.default)(endTimestamp, FETCH_THROTTLE_INTERVAL);
  const {
    buckets,
    start,
    end
  } = (0, _log_summary.useLogSummary)(logViewReference, throttledStartTimestamp, throttledEndTimestamp, serializedParsedQuery);
  return children({
    buckets,
    start,
    end
  });
};

// eslint-disable-next-line import/no-default-export
exports.WithSummary = WithSummary;
var _default = exports.default = WithSummary;