"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogPositionStateContext = exports.useLogPositionState = exports.LogPositionStateProvider = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLogPositionState = ({
  logStreamPageState,
  logStreamPageCallbacks
}) => {
  var _latestPosition$time;
  const dateRange = (0, _react.useMemo)(() => getLegacyDateRange(logStreamPageState), [logStreamPageState]);
  const {
    refreshInterval,
    targetPosition,
    visiblePositions,
    latestPosition
  } = logStreamPageState.context;
  const actions = (0, _react.useMemo)(() => {
    const {
      updateTimeRange,
      jumpToTargetPosition,
      jumpToTargetPositionTime,
      reportVisiblePositions,
      startLiveStreaming,
      stopLiveStreaming
    } = logStreamPageCallbacks;
    return {
      jumpToTargetPosition,
      jumpToTargetPositionTime,
      reportVisiblePositions,
      startLiveStreaming,
      stopLiveStreaming,
      updateDateRange: newDateRange => {
        updateTimeRange({
          from: newDateRange.startDateExpression,
          to: newDateRange.endDateExpression
        });
      }
    };
  }, [logStreamPageCallbacks]);
  const visibleTimeInterval = (0, _react.useMemo)(() => visiblePositions.startKey && visiblePositions.endKey ? {
    start: visiblePositions.startKey.time,
    end: visiblePositions.endKey.time
  } : null, [visiblePositions.startKey, visiblePositions.endKey]);
  return {
    // position state
    targetPosition,
    isStreaming: !refreshInterval.pause,
    ...dateRange,
    // visible positions state
    firstVisiblePosition: visiblePositions.startKey,
    pagesBeforeStart: visiblePositions.pagesBeforeStart,
    pagesAfterEnd: visiblePositions.pagesAfterEnd,
    visibleMidpoint: latestPosition,
    visibleMidpointTime: (_latestPosition$time = latestPosition === null || latestPosition === void 0 ? void 0 : latestPosition.time) !== null && _latestPosition$time !== void 0 ? _latestPosition$time : null,
    visibleTimeInterval,
    // actions
    ...actions
  };
};
exports.useLogPositionState = useLogPositionState;
const [LogPositionStateProvider, useLogPositionStateContext] = (0, _constate.default)(useLogPositionState);
exports.useLogPositionStateContext = useLogPositionStateContext;
exports.LogPositionStateProvider = LogPositionStateProvider;
const getLegacyDateRange = logStreamPageState => {
  return {
    startDateExpression: logStreamPageState.context.timeRange.from,
    endDateExpression: logStreamPageState.context.timeRange.to,
    startTimestamp: logStreamPageState.context.timestamps.startTimestamp,
    endTimestamp: logStreamPageState.context.timestamps.endTimestamp,
    lastCompleteDateRangeExpressionUpdate: logStreamPageState.context.timeRange.lastChangedCompletely,
    timestampsLastUpdate: logStreamPageState.context.timestamps.lastChangedTimestamp
  };
};