"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogEntryHighlights = void 0;
var _react = require("react");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_tracked_promise = require("../../../utils/use_tracked_promise");
var _fetch_log_entries_highlights = require("./api/fetch_log_entries_highlights");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLogEntryHighlights = (logViewReference, sourceVersion, startTimestamp, endTimestamp, centerPoint, size, filterQuery, highlightTerms) => {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const [logEntryHighlights, setLogEntryHighlights] = (0, _react.useState)([]);
  const [loadLogEntryHighlightsRequest, loadLogEntryHighlights] = (0, _use_tracked_promise.useTrackedPromise)({
    cancelPreviousOn: 'resolution',
    createPromise: async () => {
      if (!startTimestamp || !endTimestamp || !centerPoint || !highlightTerms.length) {
        throw new Error('Skipping request: Insufficient parameters');
      }
      return await (0, _fetch_log_entries_highlights.fetchLogEntriesHighlights)({
        logView: logViewReference,
        startTimestamp,
        endTimestamp,
        center: centerPoint,
        size,
        query: filterQuery || undefined,
        highlightTerms
      }, services.http.fetch);
    },
    onResolve: response => {
      setLogEntryHighlights(response.data);
    }
  }, [logViewReference, startTimestamp, endTimestamp, centerPoint, size, filterQuery, highlightTerms]);
  (0, _react.useEffect)(() => {
    setLogEntryHighlights([]);
  }, [highlightTerms]);
  (0, _react.useEffect)(() => {
    if (highlightTerms.filter(highlightTerm => highlightTerm.length > 0).length && startTimestamp && endTimestamp) {
      loadLogEntryHighlights();
    } else {
      setLogEntryHighlights([]);
    }
  }, [endTimestamp, filterQuery, highlightTerms, loadLogEntryHighlights, sourceVersion, startTimestamp]);
  const logEntryHighlightsById = (0, _react.useMemo)(() => logEntryHighlights.reduce((accumulatedLogEntryHighlightsById, highlightData) => {
    return highlightData.entries.reduce((singleHighlightLogEntriesById, entry) => {
      const highlightsForId = singleHighlightLogEntriesById[entry.id] || [];
      return {
        ...singleHighlightLogEntriesById,
        [entry.id]: [...highlightsForId, entry]
      };
    }, accumulatedLogEntryHighlightsById);
  }, {}), [logEntryHighlights]);
  return {
    logEntryHighlights,
    logEntryHighlightsById,
    loadLogEntryHighlightsRequest
  };
};
exports.useLogEntryHighlights = useLogEntryHighlights;