"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResettableErrorBoundary = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ResettableErrorBoundary extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      latestError: undefined
    });
    (0, _defineProperty2.default)(this, "resetError", () => {
      this.setState(previousState => ({
        ...previousState,
        latestError: undefined
      }));
    });
  }
  componentDidUpdate({
    resetOnChange: prevResetOnChange
  }) {
    const {
      resetOnChange
    } = this.props;
    const {
      latestError
    } = this.state;
    if (latestError != null && !(0, _fastDeepEqual.default)(resetOnChange, prevResetOnChange)) {
      this.resetError();
    }
  }
  static getDerivedStateFromError(error) {
    return {
      latestError: error
    };
  }
  render() {
    const {
      children,
      renderError
    } = this.props;
    const {
      latestError
    } = this.state;
    if (latestError != null) {
      return renderError({
        latestError,
        resetError: this.resetError
      });
    }
    return children;
  }
}
exports.ResettableErrorBoundary = ResettableErrorBoundary;