"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogTextStreamJumpToTail = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var React = _interopRequireWildcard(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class LogTextStreamJumpToTail extends React.PureComponent {
  render() {
    const {
      onClickJump,
      width
    } = this.props;
    return /*#__PURE__*/React.createElement(JumpToTailWrapper, {
      width: width
    }, /*#__PURE__*/React.createElement(MessageWrapper, null, /*#__PURE__*/React.createElement(_eui.EuiText, {
      color: "subdued"
    }, /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.logsShared.logs.streamingNewEntriesText",
      defaultMessage: "Streaming new entries"
    }))), /*#__PURE__*/React.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "infraJumpToMostRecentEntriesButton",
      size: "xs",
      onClick: onClickJump,
      iconType: "arrowDown"
    }, /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.logsShared.logs.jumpToTailText",
      defaultMessage: "Jump to most recent entries"
    })));
  }
}
exports.LogTextStreamJumpToTail = LogTextStreamJumpToTail;
const JumpToTailWrapper = _common.euiStyled.div`
  align-items: center;
  display: flex;
  min-height: ${props => props.theme.eui.euiSizeXXL};
  width: ${props => props.width}px;
  position: fixed;
  bottom: 0;
  background-color: ${props => props.theme.eui.euiColorEmptyShade};
`;
const MessageWrapper = _common.euiStyled.div`
  padding: 8px 16px;
`;