"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createUiSettingsServiceProxy = void 0;
var _discoverUtils = require("@kbn/discover-utils");
var _proxies = require("../utils/proxies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Create proxy for the uiSettings service, in which settings preferences are overwritten
 * with custom values
 */
const createUiSettingsServiceProxy = uiSettings => {
  const overrides = {
    [_discoverUtils.HIDE_ANNOUNCEMENTS]: true,
    [_discoverUtils.MODIFY_COLUMNS_ON_SWITCH]: false
  };
  return (0, _proxies.createPropertyGetProxy)(uiSettings, {
    get: () => (key, ...args) => {
      if (key in overrides) {
        return overrides[key];
      }
      return uiSettings.get(key, ...args);
    }
  });
};
exports.createUiSettingsServiceProxy = createUiSettingsServiceProxy;